/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.runtime.process;

import java.util.ArrayList;
import java.util.List;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.IdentityLink;
import org.activiti.rest.common.api.ActivitiUtil;
import org.activiti.rest.service.api.RestResponseFactory;
import org.activiti.rest.service.api.engine.RestIdentityLink;
import org.activiti.rest.service.api.runtime.process.BaseProcessInstanceResource;
import org.activiti.rest.service.application.ActivitiRestServicesApplication;
import org.restlet.data.Status;
import org.restlet.resource.Get;
import org.restlet.resource.Post;

public class ProcessInstanceIdentityLinkCollectionResource
extends BaseProcessInstanceResource {
    @Get
    public List<RestIdentityLink> getIdentityLinks() {
        if (!this.authenticate()) {
            return null;
        }
        ArrayList<RestIdentityLink> result = new ArrayList<RestIdentityLink>();
        ProcessInstance processInstance = this.getProcessInstanceFromRequest();
        List identityLinks = ActivitiUtil.getRuntimeService().getIdentityLinksForProcessInstance(processInstance.getId());
        RestResponseFactory responseFactory = ((ActivitiRestServicesApplication)this.getApplication(ActivitiRestServicesApplication.class)).getRestResponseFactory();
        for (IdentityLink link : identityLinks) {
            result.add(responseFactory.createRestIdentityLink(this, link));
        }
        return result;
    }

    @Post
    public RestIdentityLink createIdentityLink(RestIdentityLink identityLink) {
        if (!this.authenticate()) {
            return null;
        }
        ProcessInstance processInstance = this.getProcessInstanceFromRequest();
        if (identityLink.getGroup() != null) {
            throw new ActivitiIllegalArgumentException("Only user identity links are supported on a process instance.");
        }
        if (identityLink.getUser() == null) {
            throw new ActivitiIllegalArgumentException("The user is required.");
        }
        if (identityLink.getType() == null) {
            throw new ActivitiIllegalArgumentException("The identity link type is required.");
        }
        ActivitiUtil.getRuntimeService().addUserIdentityLink(processInstance.getId(), identityLink.getUser(), identityLink.getType());
        this.setStatus(Status.SUCCESS_CREATED);
        return ((ActivitiRestServicesApplication)this.getApplication(ActivitiRestServicesApplication.class)).getRestResponseFactory().createRestIdentityLink(this, identityLink.getType(), identityLink.getUser(), identityLink.getGroup(), null, null, processInstance.getId());
    }
}

