/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.runtime.process;

import java.util.List;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.ActivitiObjectNotFoundException;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.IdentityLink;
import org.activiti.rest.common.api.ActivitiUtil;
import org.activiti.rest.service.api.engine.RestIdentityLink;
import org.activiti.rest.service.api.runtime.process.BaseProcessInstanceResource;
import org.activiti.rest.service.application.ActivitiRestServicesApplication;
import org.restlet.resource.Get;

public class ProcessInstanceIdentityLinkResource
extends BaseProcessInstanceResource {
    @Get
    public RestIdentityLink getIdentityLink() {
        if (!this.authenticate()) {
            return null;
        }
        ProcessInstance processInstance = this.getProcessInstanceFromRequest();
        String identityId = this.getAttribute("identityId");
        String type = this.getAttribute("type");
        this.validateIdentityLinkArguments(identityId, type);
        IdentityLink link = this.getIdentityLink(identityId, type, processInstance.getId());
        return ((ActivitiRestServicesApplication)this.getApplication(ActivitiRestServicesApplication.class)).getRestResponseFactory().createRestIdentityLink(this, link);
    }

    protected void validateIdentityLinkArguments(String identityId, String type) {
        if (identityId == null) {
            throw new ActivitiIllegalArgumentException("IdentityId is required.");
        }
        if (type == null) {
            throw new ActivitiIllegalArgumentException("Type is required.");
        }
    }

    protected IdentityLink getIdentityLink(String identityId, String type, String processInstanceId) {
        List allLinks = ActivitiUtil.getRuntimeService().getIdentityLinksForProcessInstance(processInstanceId);
        for (IdentityLink link : allLinks) {
            if (!identityId.equals(link.getUserId()) || !link.getType().equals(type)) continue;
            return link;
        }
        throw new ActivitiObjectNotFoundException("Could not find the requested identity link.", IdentityLink.class);
    }
}

