/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.runtime.process;

import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.ActivitiObjectNotFoundException;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.rest.common.api.ActivitiUtil;
import org.activiti.rest.common.api.SecuredResource;
import org.activiti.rest.service.api.runtime.process.ProcessInstanceActionRequest;
import org.activiti.rest.service.api.runtime.process.ProcessInstanceResponse;
import org.activiti.rest.service.application.ActivitiRestServicesApplication;
import org.restlet.data.Status;
import org.restlet.resource.Delete;
import org.restlet.resource.Get;
import org.restlet.resource.Put;
import org.restlet.resource.ResourceException;

public class ProcessInstanceResource
extends SecuredResource {
    @Get
    public ProcessInstanceResponse getProcessInstance() {
        if (!this.authenticate()) {
            return null;
        }
        return ((ActivitiRestServicesApplication)this.getApplication(ActivitiRestServicesApplication.class)).getRestResponseFactory().createProcessInstanceResponse(this, this.getProcessInstanceFromRequest());
    }

    @Delete
    public void deleteProcessInstance() {
        if (!this.authenticate()) {
            return;
        }
        ProcessInstance processInstance = this.getProcessInstanceFromRequest();
        String deleteReason = this.getQueryParameter("deleteReason", this.getQuery());
        ActivitiUtil.getRuntimeService().deleteProcessInstance(processInstance.getId(), deleteReason);
        this.setStatus(Status.SUCCESS_NO_CONTENT);
    }

    @Put
    public ProcessInstanceResponse performProcessInstanceAction(ProcessInstanceActionRequest actionRequest) {
        if (!this.authenticate()) {
            return null;
        }
        ProcessInstance processInstance = this.getProcessInstanceFromRequest();
        if ("activate".equals(actionRequest.getAction())) {
            return this.activateProcessInstance(processInstance);
        }
        if ("suspend".equals(actionRequest.getAction())) {
            return this.suspendProcessInstance(processInstance);
        }
        throw new ActivitiIllegalArgumentException("Invalid action: '" + actionRequest.getAction() + "'.");
    }

    protected ProcessInstanceResponse activateProcessInstance(ProcessInstance processInstance) {
        if (!processInstance.isSuspended()) {
            throw new ResourceException(Status.CLIENT_ERROR_CONFLICT.getCode(), "Process instance with id '" + processInstance.getId() + "' is already active.", null, null);
        }
        ActivitiUtil.getRuntimeService().activateProcessInstanceById(processInstance.getId());
        ProcessInstanceResponse response = ((ActivitiRestServicesApplication)this.getApplication(ActivitiRestServicesApplication.class)).getRestResponseFactory().createProcessInstanceResponse(this, processInstance);
        response.setSuspended(false);
        return response;
    }

    protected ProcessInstanceResponse suspendProcessInstance(ProcessInstance processInstance) {
        if (processInstance.isSuspended()) {
            throw new ResourceException(Status.CLIENT_ERROR_CONFLICT.getCode(), "Process instance with id '" + processInstance.getId() + "' is already suspended.", null, null);
        }
        ActivitiUtil.getRuntimeService().suspendProcessInstanceById(processInstance.getId());
        ProcessInstanceResponse response = ((ActivitiRestServicesApplication)this.getApplication(ActivitiRestServicesApplication.class)).getRestResponseFactory().createProcessInstanceResponse(this, processInstance);
        response.setSuspended(true);
        return response;
    }

    protected ProcessInstance getProcessInstanceFromRequest() {
        String processInstanceId = this.getAttribute("processInstanceId");
        if (processInstanceId == null) {
            throw new ActivitiIllegalArgumentException("The processInstanceId cannot be null");
        }
        ProcessInstance processInstance = (ProcessInstance)ActivitiUtil.getRuntimeService().createProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        if (processInstance == null) {
            throw new ActivitiObjectNotFoundException("Could not find a process instance with id '" + processInstanceId + "'.", ProcessInstance.class);
        }
        return processInstance;
    }
}

