/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.runtime.task;

import java.util.HashMap;
import java.util.List;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.ActivitiObjectNotFoundException;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.impl.TaskQueryProperty;
import org.activiti.engine.query.Query;
import org.activiti.engine.query.QueryProperty;
import org.activiti.engine.task.DelegationState;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskQuery;
import org.activiti.rest.common.api.ActivitiUtil;
import org.activiti.rest.common.api.DataResponse;
import org.activiti.rest.common.api.SecuredResource;
import org.activiti.rest.service.api.RestResponseFactory;
import org.activiti.rest.service.api.engine.variable.QueryVariable;
import org.activiti.rest.service.api.runtime.task.TaskPaginateList;
import org.activiti.rest.service.api.runtime.task.TaskQueryRequest;
import org.activiti.rest.service.api.runtime.task.TaskRequest;
import org.activiti.rest.service.application.ActivitiRestServicesApplication;
import org.restlet.data.Form;

public class TaskBaseResource
extends SecuredResource {
    private static HashMap<String, QueryProperty> properties = new HashMap();

    protected DelegationState getDelegationState(String delegationState) {
        DelegationState state = null;
        if (delegationState != null) {
            if (DelegationState.RESOLVED.name().toLowerCase().equals(delegationState)) {
                return DelegationState.RESOLVED;
            }
            if (DelegationState.PENDING.name().toLowerCase().equals(delegationState)) {
                return DelegationState.PENDING;
            }
            throw new ActivitiIllegalArgumentException("Illegal value for delegationState: " + delegationState);
        }
        return state;
    }

    protected void populateTaskFromRequest(Task task, TaskRequest taskRequest) {
        if (taskRequest.isNameSet()) {
            task.setName(taskRequest.getName());
        }
        if (taskRequest.isAssigneeSet()) {
            task.setAssignee(taskRequest.getAssignee());
        }
        if (taskRequest.isDescriptionSet()) {
            task.setDescription(taskRequest.getDescription());
        }
        if (taskRequest.isDuedateSet()) {
            task.setDueDate(taskRequest.getDueDate());
        }
        if (taskRequest.isOwnerSet()) {
            task.setOwner(taskRequest.getOwner());
        }
        if (taskRequest.isParentTaskIdSet()) {
            task.setParentTaskId(taskRequest.getParentTaskId());
        }
        if (taskRequest.isPrioritySet()) {
            task.setPriority(taskRequest.getPriority());
        }
        if (taskRequest.isCategorySet()) {
            task.setCategory(taskRequest.getCategory());
        }
        if (taskRequest.isDelegationStateSet()) {
            DelegationState delegationState = this.getDelegationState(taskRequest.getDelegationState());
            task.setDelegationState(delegationState);
        }
    }

    protected DataResponse getTasksFromQueryRequest(TaskQueryRequest request) {
        DelegationState state;
        TaskQuery taskQuery = ActivitiUtil.getTaskService().createTaskQuery();
        Form query = this.getQuery();
        if (request.getName() != null) {
            taskQuery.taskName(request.getName());
        }
        if (request.getNameLike() != null) {
            taskQuery.taskNameLike(request.getNameLike());
        }
        if (request.getDescription() != null) {
            taskQuery.taskDescription(request.getDescription());
        }
        if (request.getDescriptionLike() != null) {
            taskQuery.taskDescriptionLike(request.getDescriptionLike());
        }
        if (request.getPriority() != null) {
            taskQuery.taskPriority(request.getPriority());
        }
        if (request.getMinimumPriority() != null) {
            taskQuery.taskMinPriority(request.getMinimumPriority());
        }
        if (request.getMaximumPriority() != null) {
            taskQuery.taskMaxPriority(request.getMaximumPriority());
        }
        if (request.getAssignee() != null) {
            taskQuery.taskAssignee(request.getAssignee());
        }
        if (request.getAssigneeLike() != null) {
            taskQuery.taskAssigneeLike(request.getAssigneeLike());
        }
        if (request.getOwner() != null) {
            taskQuery.taskOwner(request.getOwner());
        }
        if (request.getOwnerLike() != null) {
            taskQuery.taskOwnerLike(request.getOwnerLike());
        }
        if (request.getUnassigned() != null) {
            taskQuery.taskUnassigned();
        }
        if (request.getDelegationState() != null && (state = this.getDelegationState(request.getDelegationState())) != null) {
            taskQuery.taskDelegationState(state);
        }
        if (request.getCandidateUser() != null) {
            taskQuery.taskCandidateUser(request.getCandidateUser());
        }
        if (request.getInvolvedUser() != null) {
            taskQuery.taskInvolvedUser(request.getInvolvedUser());
        }
        if (request.getCandidateGroup() != null) {
            taskQuery.taskCandidateGroup(request.getCandidateGroup());
        }
        if (request.getProcessInstanceId() != null) {
            taskQuery.processInstanceId(request.getProcessInstanceId());
        }
        if (request.getProcessInstanceBusinessKey() != null) {
            taskQuery.processInstanceBusinessKey(request.getProcessInstanceBusinessKey());
        }
        if (request.getExecutionId() != null) {
            taskQuery.executionId(request.getExecutionId());
        }
        if (request.getCreatedOn() != null) {
            taskQuery.taskCreatedOn(request.getCreatedOn());
        }
        if (request.getCreatedBefore() != null) {
            taskQuery.taskCreatedBefore(request.getCreatedBefore());
        }
        if (request.getCreatedAfter() != null) {
            taskQuery.taskCreatedAfter(request.getCreatedAfter());
        }
        if (request.getExcludeSubTasks() != null && request.getExcludeSubTasks().booleanValue()) {
            taskQuery.excludeSubtasks();
        }
        if (request.getTaskDefinitionKey() != null) {
            taskQuery.taskDefinitionKey(request.getTaskDefinitionKey());
        }
        taskQuery.taskDefinitionKeyLike(request.getTaskDefinitionKeyLike());
        if (request.getDueDate() != null) {
            taskQuery.dueDate(request.getDueDate());
        }
        if (request.getDueBefore() != null) {
            taskQuery.dueBefore(request.getDueBefore());
        }
        if (request.getDueAfter() != null) {
            taskQuery.dueAfter(request.getDueAfter());
        }
        if (request.getWithoutDueDate() != null && request.getWithoutDueDate().booleanValue()) {
            taskQuery.withoutDueDate();
        }
        if (request.getActive() != null) {
            if (request.getActive().booleanValue()) {
                taskQuery.active();
            } else {
                taskQuery.suspended();
            }
        }
        if (request.getIncludeTaskLocalVariables() != null && request.getIncludeTaskLocalVariables().booleanValue()) {
            taskQuery.includeTaskLocalVariables();
        }
        if (request.getIncludeProcessVariables() != null && request.getIncludeProcessVariables().booleanValue()) {
            taskQuery.includeProcessVariables();
        }
        if (request.getProcessInstanceBusinessKeyLike() != null) {
            taskQuery.processInstanceBusinessKeyLike(request.getProcessInstanceBusinessKeyLike());
        }
        if (request.getProcessDefinitionKey() != null) {
            taskQuery.processDefinitionKey(request.getProcessDefinitionKey());
        }
        if (request.getProcessDefinitionKeyLike() != null) {
            taskQuery.processDefinitionKeyLike(request.getProcessDefinitionKeyLike());
        }
        if (request.getProcessDefinitionName() != null) {
            taskQuery.processDefinitionName(request.getProcessDefinitionName());
        }
        if (request.getProcessDefinitionNameLike() != null) {
            taskQuery.processDefinitionNameLike(request.getProcessDefinitionNameLike());
        }
        if (request.getTaskVariables() != null) {
            this.addTaskvariables(taskQuery, request.getTaskVariables());
        }
        if (request.getProcessInstanceVariables() != null) {
            this.addProcessvariables(taskQuery, request.getProcessInstanceVariables());
        }
        if (request.getTenantId() != null) {
            taskQuery.taskTenantId(request.getTenantId());
        }
        if (request.getTenantIdLike() != null) {
            taskQuery.taskTenantIdLike(request.getTenantIdLike());
        }
        if (Boolean.TRUE.equals(request.getWithoutTenantId())) {
            taskQuery.taskWithoutTenantId();
        }
        return new TaskPaginateList(this).paginateList(query, request, (Query)taskQuery, "id", properties);
    }

    protected void addTaskvariables(TaskQuery taskQuery, List<QueryVariable> variables) {
        block11: for (QueryVariable variable : variables) {
            if (variable.getVariableOperation() == null) {
                throw new ActivitiIllegalArgumentException("Variable operation is missing for variable: " + variable.getName());
            }
            if (variable.getValue() == null) {
                throw new ActivitiIllegalArgumentException("Variable value is missing for variable: " + variable.getName());
            }
            boolean nameLess = variable.getName() == null;
            Object actualValue = ((ActivitiRestServicesApplication)this.getApplication(ActivitiRestServicesApplication.class)).getRestResponseFactory().getVariableValue(variable);
            if (nameLess && variable.getVariableOperation() != QueryVariable.QueryVariableOperation.EQUALS) {
                throw new ActivitiIllegalArgumentException("Value-only query (without a variable-name) is only supported when using 'equals' operation.");
            }
            switch (variable.getVariableOperation()) {
                case EQUALS: {
                    if (nameLess) {
                        taskQuery.taskVariableValueEquals(actualValue);
                        continue block11;
                    }
                    taskQuery.taskVariableValueEquals(variable.getName(), actualValue);
                    continue block11;
                }
                case EQUALS_IGNORE_CASE: {
                    if (actualValue instanceof String) {
                        taskQuery.taskVariableValueEqualsIgnoreCase(variable.getName(), (String)actualValue);
                        continue block11;
                    }
                    throw new ActivitiIllegalArgumentException("Only string variable values are supported when ignoring casing, but was: " + actualValue.getClass().getName());
                }
                case NOT_EQUALS: {
                    taskQuery.taskVariableValueNotEquals(variable.getName(), actualValue);
                    continue block11;
                }
                case NOT_EQUALS_IGNORE_CASE: {
                    if (actualValue instanceof String) {
                        taskQuery.taskVariableValueNotEqualsIgnoreCase(variable.getName(), (String)actualValue);
                        continue block11;
                    }
                    throw new ActivitiIllegalArgumentException("Only string variable values are supported when ignoring casing, but was: " + actualValue.getClass().getName());
                }
                case GREATER_THAN: {
                    taskQuery.taskVariableValueGreaterThan(variable.getName(), actualValue);
                    continue block11;
                }
                case GREATER_THAN_OR_EQUALS: {
                    taskQuery.taskVariableValueGreaterThanOrEqual(variable.getName(), actualValue);
                    continue block11;
                }
                case LESS_THAN: {
                    taskQuery.taskVariableValueLessThan(variable.getName(), actualValue);
                    continue block11;
                }
                case LESS_THAN_OR_EQUALS: {
                    taskQuery.taskVariableValueLessThanOrEqual(variable.getName(), actualValue);
                    continue block11;
                }
                case LIKE: {
                    if (actualValue instanceof String) {
                        taskQuery.taskVariableValueLike(variable.getName(), (String)actualValue);
                        continue block11;
                    }
                    throw new ActivitiIllegalArgumentException("Only string variable values are supported using like, but was: " + actualValue.getClass().getName());
                }
            }
            throw new ActivitiIllegalArgumentException("Unsupported variable query operation: " + (Object)((Object)variable.getVariableOperation()));
        }
    }

    protected void addProcessvariables(TaskQuery taskQuery, List<QueryVariable> variables) {
        RestResponseFactory responseFactory = ((ActivitiRestServicesApplication)this.getApplication(ActivitiRestServicesApplication.class)).getRestResponseFactory();
        block11: for (QueryVariable variable : variables) {
            if (variable.getVariableOperation() == null) {
                throw new ActivitiIllegalArgumentException("Variable operation is missing for variable: " + variable.getName());
            }
            if (variable.getValue() == null) {
                throw new ActivitiIllegalArgumentException("Variable value is missing for variable: " + variable.getName());
            }
            boolean nameLess = variable.getName() == null;
            Object actualValue = responseFactory.getVariableValue(variable);
            if (nameLess && variable.getVariableOperation() != QueryVariable.QueryVariableOperation.EQUALS) {
                throw new ActivitiIllegalArgumentException("Value-only query (without a variable-name) is only supported when using 'equals' operation.");
            }
            switch (variable.getVariableOperation()) {
                case EQUALS: {
                    if (nameLess) {
                        taskQuery.processVariableValueEquals(actualValue);
                        continue block11;
                    }
                    taskQuery.processVariableValueEquals(variable.getName(), actualValue);
                    continue block11;
                }
                case EQUALS_IGNORE_CASE: {
                    if (actualValue instanceof String) {
                        taskQuery.processVariableValueEqualsIgnoreCase(variable.getName(), (String)actualValue);
                        continue block11;
                    }
                    throw new ActivitiIllegalArgumentException("Only string variable values are supported when ignoring casing, but was: " + actualValue.getClass().getName());
                }
                case NOT_EQUALS: {
                    taskQuery.processVariableValueNotEquals(variable.getName(), actualValue);
                    continue block11;
                }
                case NOT_EQUALS_IGNORE_CASE: {
                    if (actualValue instanceof String) {
                        taskQuery.processVariableValueNotEqualsIgnoreCase(variable.getName(), (String)actualValue);
                        continue block11;
                    }
                    throw new ActivitiIllegalArgumentException("Only string variable values are supported when ignoring casing, but was: " + actualValue.getClass().getName());
                }
                case GREATER_THAN: {
                    taskQuery.processVariableValueGreaterThan(variable.getName(), actualValue);
                    continue block11;
                }
                case GREATER_THAN_OR_EQUALS: {
                    taskQuery.processVariableValueGreaterThanOrEqual(variable.getName(), actualValue);
                    continue block11;
                }
                case LESS_THAN: {
                    taskQuery.processVariableValueLessThan(variable.getName(), actualValue);
                    continue block11;
                }
                case LESS_THAN_OR_EQUALS: {
                    taskQuery.processVariableValueLessThanOrEqual(variable.getName(), actualValue);
                    continue block11;
                }
                case LIKE: {
                    if (actualValue instanceof String) {
                        taskQuery.processVariableValueLike(variable.getName(), (String)actualValue);
                        continue block11;
                    }
                    throw new ActivitiIllegalArgumentException("Only string variable values are supported using like, but was: " + actualValue.getClass().getName());
                }
            }
            throw new ActivitiIllegalArgumentException("Unsupported variable query operation: " + (Object)((Object)variable.getVariableOperation()));
        }
    }

    protected Task getTaskFromRequest() {
        String taskId = this.getAttribute("taskId");
        if (taskId == null) {
            throw new ActivitiIllegalArgumentException("The taskId cannot be null");
        }
        Task task = (Task)ActivitiUtil.getTaskService().createTaskQuery().taskId(taskId).singleResult();
        if (task == null) {
            throw new ActivitiObjectNotFoundException("Could not find a task with id '" + taskId + "'.", Task.class);
        }
        return task;
    }

    protected HistoricTaskInstance getHistoricTaskFromRequest() {
        String taskId = this.getAttribute("taskId");
        if (taskId == null) {
            throw new ActivitiIllegalArgumentException("The taskId cannot be null");
        }
        HistoricTaskInstance task = (HistoricTaskInstance)ActivitiUtil.getHistoryService().createHistoricTaskInstanceQuery().taskId(taskId).singleResult();
        if (task == null) {
            throw new ActivitiObjectNotFoundException("Could not find a task with id '" + taskId + "'.", Task.class);
        }
        return task;
    }

    static {
        properties.put("id", (QueryProperty)TaskQueryProperty.TASK_ID);
        properties.put("name", (QueryProperty)TaskQueryProperty.NAME);
        properties.put("description", (QueryProperty)TaskQueryProperty.DESCRIPTION);
        properties.put("dueDate", (QueryProperty)TaskQueryProperty.DUE_DATE);
        properties.put("createTime", (QueryProperty)TaskQueryProperty.CREATE_TIME);
        properties.put("priority", (QueryProperty)TaskQueryProperty.PRIORITY);
        properties.put("executionId", (QueryProperty)TaskQueryProperty.EXECUTION_ID);
        properties.put("processInstanceId", (QueryProperty)TaskQueryProperty.PROCESS_INSTANCE_ID);
        properties.put("tenantId", (QueryProperty)TaskQueryProperty.TENANT_ID);
    }
}

