/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.runtime.task;

import java.util.Set;
import org.activiti.engine.task.Task;
import org.activiti.rest.common.api.ActivitiUtil;
import org.activiti.rest.common.api.DataResponse;
import org.activiti.rest.service.api.runtime.task.TaskBaseResource;
import org.activiti.rest.service.api.runtime.task.TaskQueryRequest;
import org.activiti.rest.service.api.runtime.task.TaskRequest;
import org.activiti.rest.service.api.runtime.task.TaskResponse;
import org.activiti.rest.service.application.ActivitiRestServicesApplication;
import org.restlet.data.Form;
import org.restlet.data.Status;
import org.restlet.resource.Get;
import org.restlet.resource.Post;
import org.restlet.resource.ResourceException;

public class TaskCollectionResource
extends TaskBaseResource {
    @Post
    public TaskResponse createTask(TaskRequest taskRequest) {
        if (!this.authenticate()) {
            return null;
        }
        if (taskRequest == null) {
            throw new ResourceException(new Status(Status.CLIENT_ERROR_UNSUPPORTED_MEDIA_TYPE.getCode(), "A request body was expected when creating the task.", null, null));
        }
        Task task = ActivitiUtil.getTaskService().newTask();
        this.populateTaskFromRequest(task, taskRequest);
        ActivitiUtil.getTaskService().saveTask(task);
        this.setStatus(Status.SUCCESS_CREATED);
        return ((ActivitiRestServicesApplication)this.getApplication(ActivitiRestServicesApplication.class)).getRestResponseFactory().createTaskResponse(this, task);
    }

    @Get
    public DataResponse getTasks() {
        if (!this.authenticate()) {
            return null;
        }
        TaskQueryRequest request = new TaskQueryRequest();
        Form query = this.getQuery();
        Set names = query.getNames();
        if (names.contains("name")) {
            request.setName(this.getQueryParameter("name", query));
        }
        if (names.contains("nameLike")) {
            request.setNameLike(this.getQueryParameter("nameLike", query));
        }
        if (names.contains("description")) {
            request.setDescription(this.getQueryParameter("description", query));
        }
        if (names.contains("descriptionLike")) {
            request.setDescriptionLike(this.getQueryParameter("descriptionLike", query));
        }
        if (names.contains("priority")) {
            request.setPriority(this.getQueryParameterAsInt("priority", query));
        }
        if (names.contains("minimumPriority")) {
            request.setMinimumPriority(this.getQueryParameterAsInt("minimumPriority", query));
        }
        if (names.contains("maximumPriority")) {
            request.setMaximumPriority(this.getQueryParameterAsInt("maximumPriority", query));
        }
        if (names.contains("assignee")) {
            request.setAssignee(this.getQueryParameter("assignee", query));
        }
        if (names.contains("owner")) {
            request.setOwner(this.getQueryParameter("owner", query));
        }
        if (names.contains("unassigned")) {
            request.setUnassigned(this.getQueryParameterAsBoolean("unassigned", query));
        }
        if (names.contains("delegationState")) {
            request.setDelegationState(this.getQueryParameter("delegationState", query));
        }
        if (names.contains("candidateUser")) {
            request.setCandidateUser(this.getQueryParameter("candidateUser", query));
        }
        if (names.contains("involvedUser")) {
            request.setInvolvedUser(this.getQueryParameter("involvedUser", query));
        }
        if (names.contains("candidateGroup")) {
            request.setCandidateGroup(this.getQueryParameter("candidateGroup", query));
        }
        if (names.contains("processDefinitionKey")) {
            request.setProcessDefinitionKey(this.getQueryParameter("processDefinitionKey", query));
        }
        if (names.contains("processDefinitionKeyLike")) {
            request.setProcessDefinitionKeyLike(this.getQueryParameter("processDefinitionKeyLike", query));
        }
        if (names.contains("processDefinitionName")) {
            request.setProcessDefinitionName(this.getQueryParameter("processDefinitionName", query));
        }
        if (names.contains("processDefinitionNameLike")) {
            request.setProcessDefinitionNameLike(this.getQueryParameter("processDefinitionNameLike", query));
        }
        if (names.contains("processInstanceId")) {
            request.setProcessInstanceId(this.getQueryParameter("processInstanceId", query));
        }
        if (names.contains("processInstanceBusinessKey")) {
            request.setProcessInstanceBusinessKey(this.getQueryParameter("processInstanceBusinessKey", query));
        }
        if (names.contains("executionId")) {
            request.setExecutionId(this.getQueryParameter("executionId", query));
        }
        if (names.contains("createdOn")) {
            request.setCreatedOn(this.getQueryParameterAsDate("createdOn", query));
        }
        if (names.contains("createdBefore")) {
            request.setCreatedBefore(this.getQueryParameterAsDate("createdBefore", query));
        }
        if (names.contains("createdAfter")) {
            request.setCreatedAfter(this.getQueryParameterAsDate("createdAfter", query));
        }
        if (names.contains("excludeSubTasks")) {
            request.setExcludeSubTasks(this.getQueryParameterAsBoolean("excludeSubTasks", query));
        }
        if (names.contains("taskDefinitionKey")) {
            request.setTaskDefinitionKey(this.getQueryParameter("taskDefinitionKey", query));
        }
        if (names.contains("taskDefinitionKeyLike")) {
            request.setTaskDefinitionKeyLike(this.getQueryParameter("taskDefinitionKeyLike", query));
        }
        if (names.contains("dueDate")) {
            request.setDueDate(this.getQueryParameterAsDate("dueDate", query));
        }
        if (names.contains("dueBefore")) {
            request.setDueBefore(this.getQueryParameterAsDate("dueBefore", query));
        }
        if (names.contains("dueAfter")) {
            request.setDueAfter(this.getQueryParameterAsDate("dueAfter", query));
        }
        if (names.contains("active")) {
            request.setActive(this.getQueryParameterAsBoolean("active", query));
        }
        if (names.contains("includeTaskLocalVariables")) {
            request.setIncludeTaskLocalVariables(this.getQueryParameterAsBoolean("includeTaskLocalVariables", query));
        }
        if (names.contains("includeProcessVariables")) {
            request.setIncludeProcessVariables(this.getQueryParameterAsBoolean("includeProcessVariables", query));
        }
        if (names.contains("tenantId")) {
            request.setTenantId(this.getQueryParameter("tenantId", query));
        }
        if (names.contains("tenantIdLike")) {
            request.setTenantIdLike(this.getQueryParameter("tenantIdLike", query));
        }
        if (names.contains("withoutTenantId") && Boolean.TRUE.equals(this.getQueryParameterAsBoolean("withoutTenantId", query))) {
            request.setWithoutTenantId(Boolean.TRUE);
        }
        return this.getTasksFromQueryRequest(request);
    }
}

