/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.runtime.task;

import java.util.ArrayList;
import java.util.List;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.ActivitiObjectNotFoundException;
import org.activiti.engine.task.IdentityLink;
import org.activiti.engine.task.Task;
import org.activiti.rest.common.api.ActivitiUtil;
import org.activiti.rest.service.api.RestResponseFactory;
import org.activiti.rest.service.api.engine.RestIdentityLink;
import org.activiti.rest.service.api.runtime.task.TaskBaseResource;
import org.activiti.rest.service.application.ActivitiRestServicesApplication;
import org.restlet.data.Status;
import org.restlet.resource.Delete;
import org.restlet.resource.Get;

public class TaskIdentityLinkFamilyResource
extends TaskBaseResource {
    @Get
    public List<RestIdentityLink> getIdentityLinksForFamily() {
        if (!this.authenticate()) {
            return null;
        }
        Task task = this.getTaskFromRequest();
        String family = this.getAttribute("family");
        if (family == null || !"groups".equals(family) && !"users".equals(family)) {
            throw new ActivitiIllegalArgumentException("Identity link family should be 'users' or 'groups'.");
        }
        boolean isUser = family.equals("users");
        ArrayList<RestIdentityLink> results = new ArrayList<RestIdentityLink>();
        RestResponseFactory responseFactory = ((ActivitiRestServicesApplication)this.getApplication(ActivitiRestServicesApplication.class)).getRestResponseFactory();
        List allLinks = ActivitiUtil.getTaskService().getIdentityLinksForTask(task.getId());
        for (IdentityLink link : allLinks) {
            boolean match = false;
            if (isUser) {
                match = link.getUserId() != null;
            } else {
                boolean bl = match = link.getGroupId() != null;
            }
            if (!match) continue;
            results.add(responseFactory.createRestIdentityLink(this, link));
        }
        return results;
    }

    @Delete
    public void deleteIdentityLink() {
        if (!this.authenticate()) {
            return;
        }
        Task task = this.getTaskFromRequest();
        String family = this.getAttribute("family");
        String identityId = this.getAttribute("identityId");
        String type = this.getAttribute("type");
        this.validateIdentityLinkArguments(family, identityId, type);
        this.getIdentityLink(family, identityId, type, task.getId());
        if ("users".equals(family)) {
            ActivitiUtil.getTaskService().deleteUserIdentityLink(task.getId(), identityId, type);
        } else {
            ActivitiUtil.getTaskService().deleteGroupIdentityLink(task.getId(), identityId, type);
        }
        this.setStatus(Status.SUCCESS_NO_CONTENT);
    }

    protected void validateIdentityLinkArguments(String family, String identityId, String type) {
        if (identityId == null) {
            throw new ActivitiIllegalArgumentException("IdentityId is required.");
        }
        if (type == null) {
            throw new ActivitiIllegalArgumentException("Type is required.");
        }
    }

    protected IdentityLink getIdentityLink(String family, String identityId, String type, String taskId) {
        boolean isUser = family.equals("users");
        List allLinks = ActivitiUtil.getTaskService().getIdentityLinksForTask(taskId);
        for (IdentityLink link : allLinks) {
            boolean rightIdentity = false;
            rightIdentity = isUser ? identityId.equals(link.getUserId()) : identityId.equals(link.getGroupId());
            if (!rightIdentity || !link.getType().equals(type)) continue;
            return link;
        }
        throw new ActivitiObjectNotFoundException("Could not find the requested identity link.", IdentityLink.class);
    }
}

