/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.demo;

import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.activiti.editor.constants.ModelDataJsonConstants;
import org.activiti.engine.IdentityService;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.TaskService;
import org.activiti.engine.identity.Group;
import org.activiti.engine.identity.Picture;
import org.activiti.engine.identity.User;
import org.activiti.engine.impl.util.IoUtil;
import org.activiti.engine.repository.Model;
import org.apache.commons.io.IOUtils;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ObjectNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DemoDataGenerator
implements ModelDataJsonConstants {
    protected static final Logger LOGGER = LoggerFactory.getLogger(DemoDataGenerator.class);
    protected transient ProcessEngine processEngine;
    protected transient IdentityService identityService;
    protected transient RepositoryService repositoryService;
    protected transient TaskService taskService;
    protected boolean createDemoUsersAndGroups;
    protected boolean createDemoProcessDefinitions;
    protected boolean createDemoModels;

    public void init() {
        this.identityService = this.processEngine.getIdentityService();
        this.repositoryService = this.processEngine.getRepositoryService();
        this.taskService = this.processEngine.getTaskService();
        if (this.createDemoUsersAndGroups) {
            LOGGER.info("Initializing demo groups");
            this.initDemoGroups();
            LOGGER.info("Initializing demo users");
            this.initDemoUsers();
        }
        if (this.createDemoProcessDefinitions) {
            LOGGER.info("Initializing demo process definitions");
            this.initDemoProcessDefinitions();
        }
        if (this.createDemoModels) {
            LOGGER.info("Initializing demo models");
            this.initDemoModelData();
        }
    }

    public void setProcessEngine(ProcessEngine processEngine) {
        this.processEngine = processEngine;
    }

    public void setCreateDemoUsersAndGroups(boolean createDemoUsersAndGroups) {
        this.createDemoUsersAndGroups = createDemoUsersAndGroups;
    }

    public void setCreateDemoProcessDefinitions(boolean createDemoProcessDefinitions) {
        this.createDemoProcessDefinitions = createDemoProcessDefinitions;
    }

    public void setCreateDemoModels(boolean createDemoModels) {
        this.createDemoModels = createDemoModels;
    }

    protected void initDemoGroups() {
        String[] securityGroups;
        String[] assignmentGroups;
        for (String groupId : assignmentGroups = new String[]{"management", "sales", "marketing", "engineering"}) {
            this.createGroup(groupId, "assignment");
        }
        for (String groupId : securityGroups = new String[]{"user", "admin"}) {
            this.createGroup(groupId, "security-role");
        }
    }

    protected void createGroup(String groupId, String type) {
        if (this.identityService.createGroupQuery().groupId(groupId).count() == 0L) {
            Group newGroup = this.identityService.newGroup(groupId);
            newGroup.setName(groupId.substring(0, 1).toUpperCase() + groupId.substring(1));
            newGroup.setType(type);
            this.identityService.saveGroup(newGroup);
        }
    }

    protected void initDemoUsers() {
        this.createUser("kermit", "Kermit", "The Frog", "kermit", "kermit@activiti.org", null, Arrays.asList("management", "sales", "marketing", "engineering", "user", "admin"), Arrays.asList("birthDate", "10-10-1955", "jobTitle", "Muppet", "location", "Hollywoord", "phone", "+123456789", "twitterName", "alfresco", "skype", "activiti_kermit_frog"));
        this.createUser("gonzo", "Gonzo", "The Great", "gonzo", "gonzo@activiti.org", null, Arrays.asList("management", "sales", "marketing", "user"), null);
        this.createUser("fozzie", "Fozzie", "Bear", "fozzie", "fozzie@activiti.org", null, Arrays.asList("marketing", "engineering", "user"), null);
    }

    protected void createUser(String userId, String firstName, String lastName, String password, String email, String imageResource, List<String> groups, List<String> userInfo) {
        if (this.identityService.createUserQuery().userId(userId).count() == 0L) {
            User user = this.identityService.newUser(userId);
            user.setFirstName(firstName);
            user.setLastName(lastName);
            user.setPassword(password);
            user.setEmail(email);
            this.identityService.saveUser(user);
            if (groups != null) {
                for (String group : groups) {
                    this.identityService.createMembership(userId, group);
                }
            }
        }
        if (imageResource != null) {
            byte[] pictureBytes = IoUtil.readInputStream((InputStream)this.getClass().getClassLoader().getResourceAsStream(imageResource), null);
            Picture picture = new Picture(pictureBytes, "image/jpeg");
            this.identityService.setUserPicture(userId, picture);
        }
        if (userInfo != null) {
            for (int i = 0; i < userInfo.size(); i += 2) {
                this.identityService.setUserInfo(userId, userInfo.get(i), userInfo.get(i + 1));
            }
        }
    }

    protected void initDemoProcessDefinitions() {
        String deploymentName = "Demo processes";
        List deploymentList = this.repositoryService.createDeploymentQuery().deploymentName(deploymentName).list();
        if (deploymentList == null || deploymentList.size() == 0) {
            this.repositoryService.createDeployment().name(deploymentName).addClasspathResource("createTimersProcess.bpmn20.xml").addClasspathResource("oneTaskProcess.bpmn20.xml").addClasspathResource("VacationRequest.bpmn20.xml").addClasspathResource("VacationRequest.png").addClasspathResource("FixSystemFailureProcess.bpmn20.xml").addClasspathResource("FixSystemFailureProcess.png").addClasspathResource("Helpdesk.bpmn20.xml").addClasspathResource("Helpdesk.png").addClasspathResource("reviewSalesLead.bpmn20.xml").deploy();
        }
    }

    protected void initDemoModelData() {
        this.createModelData("Demo model", "This is a demo model", "org/activiti/rest/demo/model/test.model.json");
    }

    protected void createModelData(String name, String description, String jsonFile) {
        List modelList = this.repositoryService.createModelQuery().modelName("Demo model").list();
        if (modelList == null || modelList.size() == 0) {
            Model model = this.repositoryService.newModel();
            model.setName(name);
            ObjectNode modelObjectNode = new ObjectMapper().createObjectNode();
            modelObjectNode.put("name", name);
            modelObjectNode.put("description", description);
            model.setMetaInfo(modelObjectNode.toString());
            this.repositoryService.saveModel(model);
            try {
                InputStream svgStream = this.getClass().getClassLoader().getResourceAsStream("org/activiti/rest/demo/model/test.svg");
                this.repositoryService.addModelEditorSourceExtra(model.getId(), IOUtils.toByteArray((InputStream)svgStream));
            }
            catch (Exception e) {
                LOGGER.warn("Failed to read SVG", (Throwable)e);
            }
            try {
                InputStream editorJsonStream = this.getClass().getClassLoader().getResourceAsStream(jsonFile);
                this.repositoryService.addModelEditorSource(model.getId(), IOUtils.toByteArray((InputStream)editorJsonStream));
            }
            catch (Exception e) {
                LOGGER.warn("Failed to read editor JSON", (Throwable)e);
            }
        }
    }

    protected String randomSentence(String[] words, int length) {
        Random random = new Random();
        StringBuilder strb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            strb.append(words[random.nextInt(words.length)]);
            strb.append(" ");
        }
        return strb.toString().trim();
    }
}

