/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.form;

import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.ActivitiObjectNotFoundException;
import org.activiti.engine.FormService;
import org.activiti.engine.form.FormData;
import org.activiti.engine.form.TaskFormData;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.rest.service.api.RestResponseFactory;
import org.activiti.rest.service.api.form.FormDataResponse;
import org.activiti.rest.service.api.form.RestFormProperty;
import org.activiti.rest.service.api.form.SubmitFormRequest;
import org.activiti.rest.service.api.runtime.process.ProcessInstanceResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class FormDataResource {
    @Autowired
    protected RestResponseFactory restResponseFactory;
    @Autowired
    protected FormService formService;

    @RequestMapping(value={"/form/form-data"}, method={RequestMethod.GET}, produces={"application/json"})
    public FormDataResponse getFormData(@RequestParam(value="taskId", required=false) String taskId, @RequestParam(value="processDefinitionId", required=false) String processDefinitionId, HttpServletRequest request) {
        if (taskId == null && processDefinitionId == null) {
            throw new ActivitiIllegalArgumentException("The taskId or processDefinitionId parameter has to be provided");
        }
        if (taskId != null && processDefinitionId != null) {
            throw new ActivitiIllegalArgumentException("Not both a taskId and a processDefinitionId parameter can be provided");
        }
        TaskFormData formData = null;
        String id = null;
        if (taskId != null) {
            formData = this.formService.getTaskFormData(taskId);
            id = taskId;
        } else {
            formData = this.formService.getStartFormData(processDefinitionId);
            id = processDefinitionId;
        }
        if (formData == null) {
            throw new ActivitiObjectNotFoundException("Could not find a form data with id '" + id + "'.", FormData.class);
        }
        return this.restResponseFactory.createFormDataResponse((FormData)formData, request.getRequestURL().toString().replace("/form/form-data", ""));
    }

    @RequestMapping(value={"/form/form-data"}, method={RequestMethod.POST}, produces={"application/json"})
    public ProcessInstanceResponse submitForm(@RequestBody SubmitFormRequest submitRequest, HttpServletRequest request, HttpServletResponse response) {
        if (submitRequest == null) {
            throw new ActivitiException("A request body was expected when executing the form submit.");
        }
        if (submitRequest.getTaskId() == null && submitRequest.getProcessDefinitionId() == null) {
            throw new ActivitiIllegalArgumentException("The taskId or processDefinitionId property has to be provided");
        }
        HashMap<String, String> propertyMap = new HashMap<String, String>();
        if (submitRequest.getProperties() != null) {
            for (RestFormProperty formProperty : submitRequest.getProperties()) {
                propertyMap.put(formProperty.getId(), formProperty.getValue());
            }
        }
        if (submitRequest.getTaskId() != null) {
            this.formService.submitTaskFormData(submitRequest.getTaskId(), propertyMap);
            response.setStatus(HttpStatus.NO_CONTENT.value());
            return null;
        }
        ProcessInstance processInstance = null;
        processInstance = submitRequest.getBusinessKey() != null ? this.formService.submitStartFormData(submitRequest.getProcessDefinitionId(), submitRequest.getBusinessKey(), propertyMap) : this.formService.submitStartFormData(submitRequest.getProcessDefinitionId(), propertyMap);
        return this.restResponseFactory.createProcessInstanceResponse(processInstance, request.getRequestURL().toString().replace("/form/form-data", ""));
    }
}

