/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.history;

import java.util.HashMap;
import java.util.Map;
import org.activiti.engine.HistoryService;
import org.activiti.engine.history.HistoricDetailQuery;
import org.activiti.engine.impl.HistoricDetailQueryProperty;
import org.activiti.engine.query.Query;
import org.activiti.engine.query.QueryProperty;
import org.activiti.rest.common.api.DataResponse;
import org.activiti.rest.service.api.RestResponseFactory;
import org.activiti.rest.service.api.history.HistoricDetailPaginateList;
import org.activiti.rest.service.api.history.HistoricDetailQueryRequest;
import org.springframework.beans.factory.annotation.Autowired;

public class HistoricDetailBaseResource {
    private static Map<String, QueryProperty> allowedSortProperties = new HashMap<String, QueryProperty>();
    @Autowired
    protected RestResponseFactory restResponseFactory;
    @Autowired
    protected HistoryService historyService;

    protected DataResponse getQueryResponse(HistoricDetailQueryRequest queryRequest, Map<String, String> allRequestParams, String serverRootUrl) {
        HistoricDetailQuery query = this.historyService.createHistoricDetailQuery();
        if (queryRequest.getProcessInstanceId() != null) {
            query.processInstanceId(queryRequest.getProcessInstanceId());
        }
        if (queryRequest.getExecutionId() != null) {
            query.executionId(queryRequest.getExecutionId());
        }
        if (queryRequest.getActivityInstanceId() != null) {
            query.activityInstanceId(queryRequest.getActivityInstanceId());
        }
        if (queryRequest.getTaskId() != null) {
            query.taskId(queryRequest.getTaskId());
        }
        if (queryRequest.getSelectOnlyFormProperties() != null && queryRequest.getSelectOnlyFormProperties().booleanValue()) {
            query.formProperties();
        }
        if (queryRequest.getSelectOnlyVariableUpdates() != null && queryRequest.getSelectOnlyVariableUpdates().booleanValue()) {
            query.variableUpdates();
        }
        return new HistoricDetailPaginateList(this.restResponseFactory, serverRootUrl).paginateList(allRequestParams, queryRequest, (Query)query, "processInstanceId", allowedSortProperties);
    }

    static {
        allowedSortProperties.put("processInstanceId", (QueryProperty)HistoricDetailQueryProperty.PROCESS_INSTANCE_ID);
        allowedSortProperties.put("time", (QueryProperty)HistoricDetailQueryProperty.TIME);
        allowedSortProperties.put("name", (QueryProperty)HistoricDetailQueryProperty.VARIABLE_NAME);
        allowedSortProperties.put("revision", (QueryProperty)HistoricDetailQueryProperty.VARIABLE_REVISION);
        allowedSortProperties.put("variableType", (QueryProperty)HistoricDetailQueryProperty.VARIABLE_TYPE);
    }
}

