/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.history;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.activiti.engine.ActivitiObjectNotFoundException;
import org.activiti.engine.HistoryService;
import org.activiti.engine.TaskService;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.task.Comment;
import org.activiti.rest.service.api.RestResponseFactory;
import org.activiti.rest.service.api.engine.CommentResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class HistoricProcessInstanceCommentResource {
    @Autowired
    protected RestResponseFactory restResponseFactory;
    @Autowired
    protected HistoryService historyService;
    @Autowired
    protected TaskService taskService;

    @RequestMapping(value={"/history/historic-process-instances/{processInstanceId}/comments/{commentId}"}, method={RequestMethod.GET}, produces={"application/json"})
    public CommentResponse getComment(@PathVariable(value="processInstanceId") String processInstanceId, @PathVariable(value="commentId") String commentId, HttpServletRequest request) {
        HistoricProcessInstance instance = this.getHistoricProcessInstanceFromRequest(processInstanceId);
        Comment comment = this.taskService.getComment(commentId);
        if (comment == null || comment.getProcessInstanceId() == null || !comment.getProcessInstanceId().equals(instance.getId())) {
            throw new ActivitiObjectNotFoundException("Process instance '" + instance.getId() + "' doesn't have a comment with id '" + commentId + "'.", Comment.class);
        }
        String serverRootUrl = request.getRequestURL().toString();
        serverRootUrl = serverRootUrl.substring(0, serverRootUrl.indexOf("/history/historic-process-instances/"));
        return this.restResponseFactory.createRestComment(comment, serverRootUrl);
    }

    @RequestMapping(value={"/history/historic-process-instances/{processInstanceId}/comments/{commentId}"}, method={RequestMethod.DELETE})
    public void deleteComment(@PathVariable(value="processInstanceId") String processInstanceId, @PathVariable(value="commentId") String commentId, HttpServletRequest request, HttpServletResponse response) {
        HistoricProcessInstance instance = this.getHistoricProcessInstanceFromRequest(processInstanceId);
        Comment comment = this.taskService.getComment(commentId);
        if (comment == null || comment.getProcessInstanceId() == null || !comment.getProcessInstanceId().equals(instance.getId())) {
            throw new ActivitiObjectNotFoundException("Process instance '" + instance.getId() + "' doesn't have a comment with id '" + commentId + "'.", Comment.class);
        }
        this.taskService.deleteComment(commentId);
        response.setStatus(HttpStatus.NO_CONTENT.value());
    }

    protected HistoricProcessInstance getHistoricProcessInstanceFromRequest(String processInstanceId) {
        HistoricProcessInstance processInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        if (processInstance == null) {
            throw new ActivitiObjectNotFoundException("Could not find a process instance with id '" + processInstanceId + "'.", HistoricProcessInstance.class);
        }
        return processInstance;
    }
}

