/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.history;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.activiti.engine.HistoryService;
import org.activiti.engine.history.HistoricIdentityLink;
import org.activiti.rest.service.api.RestResponseFactory;
import org.activiti.rest.service.api.history.HistoricIdentityLinkResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class HistoricTaskInstanceIdentityLinkCollectionResource {
    @Autowired
    protected RestResponseFactory restResponseFactory;
    @Autowired
    protected HistoryService historyService;

    @RequestMapping(value={"/history/historic-task-instances/{taskId}/identitylinks"}, method={RequestMethod.GET}, produces={"application/json"})
    public List<HistoricIdentityLinkResponse> getTaskIdentityLinks(@PathVariable String taskId, HttpServletRequest request) {
        List identityLinks = this.historyService.getHistoricIdentityLinksForTask(taskId);
        String serverRootUrl = request.getRequestURL().toString();
        serverRootUrl = serverRootUrl.substring(0, serverRootUrl.indexOf("/history/historic-task-instances/"));
        ArrayList<HistoricIdentityLinkResponse> responseList = new ArrayList<HistoricIdentityLinkResponse>();
        if (identityLinks != null) {
            for (HistoricIdentityLink instance : identityLinks) {
                responseList.add(this.restResponseFactory.createHistoricIdentityLinkResponse(instance, serverRootUrl));
            }
        }
        return responseList;
    }
}

