/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.identity;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.identity.Group;
import org.activiti.rest.exception.ActivitiConflictException;
import org.activiti.rest.service.api.identity.BaseGroupResource;
import org.activiti.rest.service.api.identity.MembershipRequest;
import org.activiti.rest.service.api.identity.MembershipResponse;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class GroupMembershipCollectionResource
extends BaseGroupResource {
    @RequestMapping(value={"/identity/groups/{groupId}/members"}, method={RequestMethod.POST}, produces={"application/json"})
    public MembershipResponse createMembership(@PathVariable String groupId, @RequestBody MembershipRequest memberShip, HttpServletRequest request, HttpServletResponse response) {
        Group group = this.getGroupFromRequest(groupId);
        if (memberShip.getUserId() == null) {
            throw new ActivitiIllegalArgumentException("UserId cannot be null.");
        }
        if (this.identityService.createUserQuery().memberOfGroup(group.getId()).userId(memberShip.getUserId()).count() > 0L) {
            throw new ActivitiConflictException("User '" + memberShip.getUserId() + "' is already part of group '" + group.getId() + "'.");
        }
        this.identityService.createMembership(memberShip.getUserId(), group.getId());
        response.setStatus(HttpStatus.CREATED.value());
        String serverRootUrl = request.getRequestURL().toString();
        serverRootUrl = serverRootUrl.substring(0, serverRootUrl.indexOf("/identity/groups/"));
        return this.restResponseFactory.createMembershipResponse(memberShip.getUserId(), group.getId(), serverRootUrl);
    }
}

