/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.identity;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.identity.Group;
import org.activiti.rest.service.api.identity.BaseGroupResource;
import org.activiti.rest.service.api.identity.GroupRequest;
import org.activiti.rest.service.api.identity.GroupResponse;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class GroupResource
extends BaseGroupResource {
    @RequestMapping(value={"/identity/groups/{groupId}"}, method={RequestMethod.GET}, produces={"application/json"})
    public GroupResponse getGroup(@PathVariable String groupId, HttpServletRequest request) {
        String serverRootUrl = request.getRequestURL().toString();
        serverRootUrl = serverRootUrl.substring(0, serverRootUrl.indexOf("/identity/groups/"));
        return this.restResponseFactory.createGroupResponse(this.getGroupFromRequest(groupId), serverRootUrl);
    }

    @RequestMapping(value={"/identity/groups/{groupId}"}, method={RequestMethod.PUT}, produces={"application/json"})
    public GroupResponse updateGroup(@PathVariable String groupId, @RequestBody GroupRequest groupRequest, HttpServletRequest request) {
        Group group = this.getGroupFromRequest(groupId);
        if (groupRequest.getId() == null || groupRequest.getId().equals(group.getId())) {
            if (groupRequest.isNameChanged()) {
                group.setName(groupRequest.getName());
            }
            if (groupRequest.isTypeChanged()) {
                group.setType(groupRequest.getType());
            }
        } else {
            throw new ActivitiIllegalArgumentException("Key provided in request body doesn't match the key in the resource URL.");
        }
        this.identityService.saveGroup(group);
        String serverRootUrl = request.getRequestURL().toString();
        serverRootUrl = serverRootUrl.substring(0, serverRootUrl.indexOf("/identity/groups/"));
        return this.restResponseFactory.createGroupResponse(group, serverRootUrl);
    }

    @RequestMapping(value={"/identity/groups/{groupId}"}, method={RequestMethod.DELETE})
    public void deleteGroup(@PathVariable String groupId, HttpServletResponse response) {
        Group group = this.getGroupFromRequest(groupId);
        this.identityService.deleteGroup(group.getId());
        response.setStatus(HttpStatus.NO_CONTENT.value());
    }
}

