/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.identity;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.IdentityService;
import org.activiti.engine.identity.User;
import org.activiti.engine.identity.UserQuery;
import org.activiti.engine.impl.UserQueryProperty;
import org.activiti.engine.query.Query;
import org.activiti.engine.query.QueryProperty;
import org.activiti.rest.common.api.DataResponse;
import org.activiti.rest.exception.ActivitiConflictException;
import org.activiti.rest.service.api.RestResponseFactory;
import org.activiti.rest.service.api.identity.UserPaginateList;
import org.activiti.rest.service.api.identity.UserRequest;
import org.activiti.rest.service.api.identity.UserResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class UserCollectionResource {
    protected static HashMap<String, QueryProperty> properties = new HashMap();
    @Autowired
    protected RestResponseFactory restResponseFactory;
    @Autowired
    protected IdentityService identityService;

    @RequestMapping(value={"/identity/users"}, method={RequestMethod.GET}, produces={"application/json"})
    public DataResponse getUsers(@RequestParam Map<String, String> allRequestParams, HttpServletRequest request) {
        UserQuery query = this.identityService.createUserQuery();
        if (allRequestParams.containsKey("id")) {
            query.userId(allRequestParams.get("id"));
        }
        if (allRequestParams.containsKey("firstName")) {
            query.userFirstName(allRequestParams.get("firstName"));
        }
        if (allRequestParams.containsKey("lastName")) {
            query.userLastName(allRequestParams.get("lastName"));
        }
        if (allRequestParams.containsKey("email")) {
            query.userEmail(allRequestParams.get("email"));
        }
        if (allRequestParams.containsKey("firstNameLike")) {
            query.userFirstNameLike(allRequestParams.get("firstNameLike"));
        }
        if (allRequestParams.containsKey("lastNameLike")) {
            query.userLastNameLike(allRequestParams.get("lastNameLike"));
        }
        if (allRequestParams.containsKey("emailLike")) {
            query.userEmailLike(allRequestParams.get("emailLike"));
        }
        if (allRequestParams.containsKey("memberOfGroup")) {
            query.memberOfGroup(allRequestParams.get("memberOfGroup"));
        }
        if (allRequestParams.containsKey("potentialStarter")) {
            query.potentialStarter(allRequestParams.get("potentialStarter"));
        }
        return new UserPaginateList(this.restResponseFactory, request.getRequestURL().toString().replace("/identity/users", "")).paginateList(allRequestParams, (Query)query, "id", properties);
    }

    @RequestMapping(value={"/identity/users"}, method={RequestMethod.POST}, produces={"application/json"})
    public UserResponse createUser(@RequestBody UserRequest userRequest, HttpServletRequest request, HttpServletResponse response) {
        if (userRequest.getId() == null) {
            throw new ActivitiIllegalArgumentException("Id cannot be null.");
        }
        if (this.identityService.createUserQuery().userId(userRequest.getId()).count() > 0L) {
            throw new ActivitiConflictException("A user with id '" + userRequest.getId() + "' already exists.");
        }
        User created = this.identityService.newUser(userRequest.getId());
        created.setEmail(userRequest.getEmail());
        created.setFirstName(userRequest.getFirstName());
        created.setLastName(userRequest.getLastName());
        created.setPassword(userRequest.getPassword());
        this.identityService.saveUser(created);
        response.setStatus(HttpStatus.CREATED.value());
        return this.restResponseFactory.createUserResponse(created, true, request.getRequestURL().toString().replace("/identity/users", ""));
    }

    static {
        properties.put("id", (QueryProperty)UserQueryProperty.USER_ID);
        properties.put("firstName", (QueryProperty)UserQueryProperty.FIRST_NAME);
        properties.put("lastName", (QueryProperty)UserQueryProperty.LAST_NAME);
        properties.put("email", (QueryProperty)UserQueryProperty.EMAIL);
    }
}

