/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.identity;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.IdentityService;
import org.activiti.engine.identity.User;
import org.activiti.rest.exception.ActivitiConflictException;
import org.activiti.rest.service.api.RestResponseFactory;
import org.activiti.rest.service.api.identity.BaseUserResource;
import org.activiti.rest.service.api.identity.UserInfoRequest;
import org.activiti.rest.service.api.identity.UserInfoResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class UserInfoCollectionResource
extends BaseUserResource {
    @Autowired
    protected RestResponseFactory restResponseFactory;
    @Autowired
    protected IdentityService identityService;

    @RequestMapping(value={"/identity/users/{userId}/info"}, method={RequestMethod.GET}, produces={"application/json"})
    public List<UserInfoResponse> getUserInfo(@PathVariable String userId, HttpServletRequest request) {
        User user = this.getUserFromRequest(userId);
        ArrayList<UserInfoResponse> responses = new ArrayList<UserInfoResponse>();
        String serverRootUrl = request.getRequestURL().toString();
        serverRootUrl = serverRootUrl.substring(0, serverRootUrl.indexOf("/identity/users/"));
        for (String key : this.identityService.getUserInfoKeys(user.getId())) {
            responses.add(this.restResponseFactory.createUserInfoResponse(key, null, user.getId(), serverRootUrl));
        }
        return responses;
    }

    @RequestMapping(value={"/identity/users/{userId}/info"}, method={RequestMethod.POST}, produces={"application/json"})
    public UserInfoResponse setUserInfo(@PathVariable String userId, @RequestBody UserInfoRequest userRequest, HttpServletRequest request, HttpServletResponse response) {
        User user = this.getUserFromRequest(userId);
        if (userRequest.getKey() == null) {
            throw new ActivitiIllegalArgumentException("The key cannot be null.");
        }
        if (userRequest.getValue() == null) {
            throw new ActivitiIllegalArgumentException("The value cannot be null.");
        }
        String existingValue = this.identityService.getUserInfo(user.getId(), userRequest.getKey());
        if (existingValue != null) {
            throw new ActivitiConflictException("User info with key '" + userRequest.getKey() + "' already exists for this user.");
        }
        this.identityService.setUserInfo(user.getId(), userRequest.getKey(), userRequest.getValue());
        response.setStatus(HttpStatus.CREATED.value());
        String serverRootUrl = request.getRequestURL().toString();
        serverRootUrl = serverRootUrl.substring(0, serverRootUrl.indexOf("/identity/users/"));
        return this.restResponseFactory.createUserInfoResponse(userRequest.getKey(), userRequest.getValue(), user.getId(), serverRootUrl);
    }
}

