/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.identity;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.ActivitiObjectNotFoundException;
import org.activiti.engine.IdentityService;
import org.activiti.engine.identity.User;
import org.activiti.rest.service.api.RestResponseFactory;
import org.activiti.rest.service.api.identity.BaseUserResource;
import org.activiti.rest.service.api.identity.UserInfoRequest;
import org.activiti.rest.service.api.identity.UserInfoResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class UserInfoResource
extends BaseUserResource {
    @Autowired
    protected RestResponseFactory restResponseFactory;
    @Autowired
    protected IdentityService identityService;

    @RequestMapping(value={"/identity/users/{userId}/info/{key}"}, method={RequestMethod.GET}, produces={"application/json"})
    public UserInfoResponse getUserInfo(@PathVariable(value="userId") String userId, @PathVariable(value="key") String key, HttpServletRequest request) {
        User user = this.getUserFromRequest(userId);
        String existingValue = this.identityService.getUserInfo(user.getId(), key);
        if (existingValue == null) {
            throw new ActivitiObjectNotFoundException("User info with key '" + key + "' does not exists for user '" + user.getId() + "'.", null);
        }
        String serverRootUrl = request.getRequestURL().toString();
        serverRootUrl = serverRootUrl.substring(0, serverRootUrl.indexOf("/identity/users/"));
        return this.restResponseFactory.createUserInfoResponse(key, existingValue, user.getId(), serverRootUrl);
    }

    @RequestMapping(value={"/identity/users/{userId}/info/{key}"}, method={RequestMethod.PUT}, produces={"application/json"})
    public UserInfoResponse setUserInfo(@PathVariable(value="userId") String userId, @PathVariable(value="key") String key, @RequestBody UserInfoRequest userRequest, HttpServletRequest request) {
        User user = this.getUserFromRequest(userId);
        String validKey = this.getValidKeyFromRequest(user, key);
        if (userRequest.getValue() == null) {
            throw new ActivitiIllegalArgumentException("The value cannot be null.");
        }
        if (userRequest.getKey() != null && !validKey.equals(userRequest.getKey())) {
            throw new ActivitiIllegalArgumentException("Key provided in request body doesn't match the key in the resource URL.");
        }
        this.identityService.setUserInfo(user.getId(), key, userRequest.getValue());
        String serverRootUrl = request.getRequestURL().toString();
        serverRootUrl = serverRootUrl.substring(0, serverRootUrl.indexOf("/identity/users/"));
        return this.restResponseFactory.createUserInfoResponse(key, userRequest.getValue(), user.getId(), serverRootUrl);
    }

    @RequestMapping(value={"/identity/users/{userId}/info/{key}"}, method={RequestMethod.DELETE})
    public void deleteUserInfo(@PathVariable(value="userId") String userId, @PathVariable(value="key") String key, HttpServletResponse response) {
        User user = this.getUserFromRequest(userId);
        String validKey = this.getValidKeyFromRequest(user, key);
        this.identityService.setUserInfo(user.getId(), validKey, null);
        response.setStatus(HttpStatus.NO_CONTENT.value());
    }

    protected String getValidKeyFromRequest(User user, String key) {
        String existingValue = this.identityService.getUserInfo(user.getId(), key);
        if (existingValue == null) {
            throw new ActivitiObjectNotFoundException("User info with key '" + key + "' does not exists for user '" + user.getId() + "'.", null);
        }
        return key;
    }
}

