/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.identity;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.ActivitiObjectNotFoundException;
import org.activiti.engine.identity.Picture;
import org.activiti.engine.identity.User;
import org.activiti.rest.service.api.identity.BaseUserResource;
import org.apache.commons.io.IOUtils;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@RestController
public class UserPictureResource
extends BaseUserResource {
    @RequestMapping(value={"/identity/users/{userId}/picture"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public byte[] getUserPicture(@PathVariable String userId, HttpServletRequest request, HttpServletResponse response) {
        User user = this.getUserFromRequest(userId);
        Picture userPicture = this.identityService.getUserPicture(user.getId());
        if (userPicture == null) {
            throw new ActivitiObjectNotFoundException("The user with id '" + user.getId() + "' does not have a picture.", Picture.class);
        }
        String mediaType = "image/jpeg";
        if (userPicture.getMimeType() != null) {
            mediaType = userPicture.getMimeType();
        }
        response.setContentType(mediaType);
        try {
            return IOUtils.toByteArray((InputStream)userPicture.getInputStream());
        }
        catch (Exception e) {
            throw new ActivitiException("Error exporting picture: " + e.getMessage(), (Throwable)e);
        }
    }

    @RequestMapping(value={"/identity/users/{userId}/picture"}, method={RequestMethod.PUT})
    public void updateUserPicture(@PathVariable String userId, HttpServletRequest request, HttpServletResponse response) {
        User user = this.getUserFromRequest(userId);
        if (!(request instanceof MultipartHttpServletRequest)) {
            throw new ActivitiIllegalArgumentException("Multipart request is required");
        }
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        if (multipartRequest.getFileMap().size() == 0) {
            throw new ActivitiIllegalArgumentException("Multipart request with file content is required");
        }
        MultipartFile file = (MultipartFile)multipartRequest.getFileMap().values().iterator().next();
        try {
            String mimeType = file.getContentType();
            int size = Long.valueOf(file.getSize()).intValue();
            ByteArrayOutputStream bytesOutput = new ByteArrayOutputStream(size);
            IOUtils.copy((InputStream)file.getInputStream(), (OutputStream)bytesOutput);
            Picture newPicture = new Picture(bytesOutput.toByteArray(), mimeType);
            this.identityService.setUserPicture(user.getId(), newPicture);
            response.setStatus(HttpStatus.NO_CONTENT.value());
        }
        catch (Exception e) {
            throw new ActivitiException("Error while reading uploaded file: " + e.getMessage(), (Throwable)e);
        }
    }
}

