/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.management;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.ManagementService;
import org.activiti.engine.impl.JobQueryProperty;
import org.activiti.engine.query.Query;
import org.activiti.engine.query.QueryProperty;
import org.activiti.engine.runtime.JobQuery;
import org.activiti.rest.common.api.DataResponse;
import org.activiti.rest.common.api.RequestUtil;
import org.activiti.rest.service.api.RestResponseFactory;
import org.activiti.rest.service.api.management.JobPaginateList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class JobCollectionResource {
    protected static Map<String, QueryProperty> properties = new HashMap<String, QueryProperty>();
    @Autowired
    protected RestResponseFactory restResponseFactory;
    @Autowired
    protected ManagementService managementService;

    @RequestMapping(value={"/management/jobs"}, method={RequestMethod.GET}, produces={"application/json"})
    public DataResponse getJobs(@RequestParam Map<String, String> allRequestParams, HttpServletRequest request) {
        JobQuery query = this.managementService.createJobQuery();
        if (allRequestParams.containsKey("id")) {
            query.jobId(allRequestParams.get("id"));
        }
        if (allRequestParams.containsKey("processInstanceId")) {
            query.processInstanceId(allRequestParams.get("processInstanceId"));
        }
        if (allRequestParams.containsKey("executionId")) {
            query.executionId(allRequestParams.get("executionId"));
        }
        if (allRequestParams.containsKey("processDefinitionId")) {
            query.processDefinitionId(allRequestParams.get("processDefinitionId"));
        }
        if (allRequestParams.containsKey("withRetriesLeft") && Boolean.valueOf(allRequestParams.get("withRetriesLeft")).booleanValue()) {
            query.withRetriesLeft();
        }
        if (allRequestParams.containsKey("executable") && Boolean.valueOf(allRequestParams.get("executable")).booleanValue()) {
            query.executable();
        }
        if (allRequestParams.containsKey("timersOnly")) {
            if (allRequestParams.containsKey("messagesOnly")) {
                throw new ActivitiIllegalArgumentException("Only one of 'timersOnly' or 'messagesOnly' can be provided.");
            }
            if (Boolean.valueOf(allRequestParams.get("timersOnly")).booleanValue()) {
                query.timers();
            }
        }
        if (allRequestParams.containsKey("messagesOnly") && Boolean.valueOf(allRequestParams.get("messagesOnly")).booleanValue()) {
            query.messages();
        }
        if (allRequestParams.containsKey("dueBefore")) {
            query.duedateLowerThan(RequestUtil.getDate(allRequestParams, (String)"dueBefore"));
        }
        if (allRequestParams.containsKey("dueAfter")) {
            query.duedateHigherThan(RequestUtil.getDate(allRequestParams, (String)"dueAfter"));
        }
        if (allRequestParams.containsKey("withException") && Boolean.valueOf(allRequestParams.get("withException")).booleanValue()) {
            query.withException();
        }
        if (allRequestParams.containsKey("exceptionMessage")) {
            query.exceptionMessage(allRequestParams.get("exceptionMessage"));
        }
        if (allRequestParams.containsKey("tenantId")) {
            query.jobTenantId(allRequestParams.get("tenantId"));
        }
        if (allRequestParams.containsKey("tenantIdLike")) {
            query.jobTenantIdLike(allRequestParams.get("tenantIdLike"));
        }
        if (allRequestParams.containsKey("withoutTenantId") && Boolean.valueOf(allRequestParams.get("withoutTenantId")).booleanValue()) {
            query.jobWithoutTenantId();
        }
        return new JobPaginateList(this.restResponseFactory, request.getRequestURL().toString().replace("/management/jobs", "")).paginateList(allRequestParams, (Query)query, "id", properties);
    }

    static {
        properties.put("id", (QueryProperty)JobQueryProperty.JOB_ID);
        properties.put("dueDate", (QueryProperty)JobQueryProperty.DUEDATE);
        properties.put("executionId", (QueryProperty)JobQueryProperty.EXECUTION_ID);
        properties.put("processInstanceId", (QueryProperty)JobQueryProperty.PROCESS_INSTANCE_ID);
        properties.put("retries", (QueryProperty)JobQueryProperty.RETRIES);
        properties.put("tenantId", (QueryProperty)JobQueryProperty.TENANT_ID);
    }
}

