/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.management;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.ActivitiObjectNotFoundException;
import org.activiti.engine.ManagementService;
import org.activiti.engine.runtime.Job;
import org.activiti.rest.service.api.RestActionRequest;
import org.activiti.rest.service.api.RestResponseFactory;
import org.activiti.rest.service.api.management.JobResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class JobResource {
    private static final String EXECUTE_ACTION = "execute";
    @Autowired
    protected RestResponseFactory restResponseFactory;
    @Autowired
    protected ManagementService managementService;

    @RequestMapping(value={"/management/jobs/{jobId}"}, method={RequestMethod.GET}, produces={"application/json"})
    public JobResponse getJob(@PathVariable String jobId, HttpServletRequest request) {
        Job job = this.getJobFromResponse(jobId);
        String serverRootUrl = request.getRequestURL().toString();
        serverRootUrl = serverRootUrl.substring(0, serverRootUrl.indexOf("/management/jobs/"));
        JobResponse response = this.restResponseFactory.createJobResponse(job, serverRootUrl);
        return response;
    }

    @RequestMapping(value={"/management/jobs/{jobId}"}, method={RequestMethod.DELETE})
    public void deleteJob(@PathVariable String jobId, HttpServletResponse response) {
        try {
            this.managementService.deleteJob(jobId);
        }
        catch (ActivitiObjectNotFoundException aonfe) {
            throw new ActivitiObjectNotFoundException("Could not find a job with id '" + jobId + "'.", Job.class);
        }
        response.setStatus(HttpStatus.NO_CONTENT.value());
    }

    @RequestMapping(value={"/management/jobs/{jobId}"}, method={RequestMethod.POST})
    public void executeJobAction(@PathVariable String jobId, @RequestBody RestActionRequest actionRequest, HttpServletResponse response) {
        if (actionRequest == null || !EXECUTE_ACTION.equals(actionRequest.getAction())) {
            throw new ActivitiIllegalArgumentException("Invalid action, only 'execute' is supported.");
        }
        try {
            this.managementService.executeJob(jobId);
        }
        catch (ActivitiObjectNotFoundException aonfe) {
            throw new ActivitiObjectNotFoundException("Could not find a job with id '" + jobId + "'.", Job.class);
        }
        response.setStatus(HttpStatus.NO_CONTENT.value());
    }

    protected Job getJobFromResponse(String jobId) {
        Job job = (Job)this.managementService.createJobQuery().jobId(jobId).singleResult();
        if (job == null) {
            throw new ActivitiObjectNotFoundException("Could not find a job with id '" + jobId + "'.", Job.class);
        }
        return job;
    }
}

