/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.repository;

import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.impl.DeploymentQueryProperty;
import org.activiti.engine.query.Query;
import org.activiti.engine.query.QueryProperty;
import org.activiti.engine.repository.Deployment;
import org.activiti.engine.repository.DeploymentBuilder;
import org.activiti.engine.repository.DeploymentQuery;
import org.activiti.rest.common.api.DataResponse;
import org.activiti.rest.service.api.RestResponseFactory;
import org.activiti.rest.service.api.repository.DeploymentResponse;
import org.activiti.rest.service.api.repository.DeploymentsPaginateList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@RestController
public class DeploymentCollectionResource {
    protected static final String DEPRECATED_API_DEPLOYMENT_SEGMENT = "deployment";
    private static Map<String, QueryProperty> allowedSortProperties = new HashMap<String, QueryProperty>();
    @Autowired
    protected RestResponseFactory restResponseFactory;
    @Autowired
    protected RepositoryService repositoryService;

    @RequestMapping(value={"/repository/deployments"}, method={RequestMethod.GET}, produces={"application/json"})
    public DataResponse getDeployments(@RequestParam Map<String, String> allRequestParams, HttpServletRequest request) {
        Boolean withoutTenantId;
        DeploymentQuery deploymentQuery = this.repositoryService.createDeploymentQuery();
        if (allRequestParams.containsKey("name")) {
            deploymentQuery.deploymentName(allRequestParams.get("name"));
        }
        if (allRequestParams.containsKey("nameLike")) {
            deploymentQuery.deploymentNameLike(allRequestParams.get("nameLike"));
        }
        if (allRequestParams.containsKey("category")) {
            deploymentQuery.deploymentCategory(allRequestParams.get("category"));
        }
        if (allRequestParams.containsKey("categoryNotEquals")) {
            deploymentQuery.deploymentCategoryNotEquals(allRequestParams.get("categoryNotEquals"));
        }
        if (allRequestParams.containsKey("tenantId")) {
            deploymentQuery.deploymentTenantId(allRequestParams.get("tenantId"));
        }
        if (allRequestParams.containsKey("tenantIdLike")) {
            deploymentQuery.deploymentTenantIdLike(allRequestParams.get("tenantIdLike"));
        }
        if (allRequestParams.containsKey("withoutTenantId") && (withoutTenantId = Boolean.valueOf(allRequestParams.get("withoutTenantId"))).booleanValue()) {
            deploymentQuery.deploymentWithoutTenantId();
        }
        DataResponse response = new DeploymentsPaginateList(this.restResponseFactory, request.getRequestURL().toString().replace("/repository/deployments", "")).paginateList(allRequestParams, (Query)deploymentQuery, "id", allowedSortProperties);
        return response;
    }

    @RequestMapping(value={"/repository/deployments"}, method={RequestMethod.POST}, produces={"application/json"})
    public DeploymentResponse uploadDeployment(@RequestParam(value="tenantId", required=false) String tenantId, HttpServletRequest request, HttpServletResponse response) {
        if (!(request instanceof MultipartHttpServletRequest)) {
            throw new ActivitiIllegalArgumentException("Multipart request is required");
        }
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        if (multipartRequest.getFileMap().size() == 0) {
            throw new ActivitiIllegalArgumentException("Multipart request with file content is required");
        }
        MultipartFile file = (MultipartFile)multipartRequest.getFileMap().values().iterator().next();
        try {
            DeploymentBuilder deploymentBuilder = this.repositoryService.createDeployment();
            String fileName = file.getName();
            if (fileName.endsWith(".bpmn20.xml") || fileName.endsWith(".bpmn")) {
                deploymentBuilder.addInputStream(fileName, file.getInputStream());
            } else if (fileName.toLowerCase().endsWith(".bar") || fileName.toLowerCase().endsWith(".zip")) {
                deploymentBuilder.addZipInputStream(new ZipInputStream(file.getInputStream()));
            } else {
                throw new ActivitiIllegalArgumentException("File must be of type .bpmn20.xml, .bpmn, .bar or .zip");
            }
            deploymentBuilder.name(fileName);
            if (tenantId != null) {
                deploymentBuilder.tenantId(tenantId);
            }
            Deployment deployment = deploymentBuilder.deploy();
            response.setStatus(HttpStatus.CREATED.value());
            return this.restResponseFactory.createDeploymentResponse(deployment, request.getRequestURL().toString().replace("/repository/deployments", ""));
        }
        catch (Exception e) {
            if (e instanceof ActivitiException) {
                throw (ActivitiException)e;
            }
            throw new ActivitiException(e.getMessage(), (Throwable)e);
        }
    }

    static {
        allowedSortProperties.put("id", (QueryProperty)DeploymentQueryProperty.DEPLOYMENT_ID);
        allowedSortProperties.put("name", (QueryProperty)DeploymentQueryProperty.DEPLOYMENT_NAME);
        allowedSortProperties.put("deployTime", (QueryProperty)DeploymentQueryProperty.DEPLOY_TIME);
        allowedSortProperties.put("tenantId", (QueryProperty)DeploymentQueryProperty.DEPLOYMENT_TENANT_ID);
    }
}

