/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.repository;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.activiti.engine.ActivitiObjectNotFoundException;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.repository.Deployment;
import org.activiti.rest.service.api.RestResponseFactory;
import org.activiti.rest.service.api.repository.DeploymentResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class DeploymentResource {
    @Autowired
    protected RestResponseFactory restResponseFactory;
    @Autowired
    protected RepositoryService repositoryService;

    @RequestMapping(value={"/repository/deployments/{deploymentId}"}, method={RequestMethod.GET}, produces={"application/json"})
    public DeploymentResponse getDeployment(@PathVariable String deploymentId, HttpServletRequest request) {
        Deployment deployment = (Deployment)this.repositoryService.createDeploymentQuery().deploymentId(deploymentId).singleResult();
        if (deployment == null) {
            throw new ActivitiObjectNotFoundException("Could not find a deployment with id '" + deploymentId + "'.", Deployment.class);
        }
        String serverRootUrl = request.getRequestURL().toString();
        serverRootUrl = serverRootUrl.substring(0, serverRootUrl.indexOf("/repository/deployments/"));
        return this.restResponseFactory.createDeploymentResponse(deployment, serverRootUrl);
    }

    @RequestMapping(value={"/repository/deployments/{deploymentId}"}, method={RequestMethod.DELETE}, produces={"application/json"})
    public void deleteDeployment(@PathVariable String deploymentId, @RequestParam(value="cascade", required=false, defaultValue="false") Boolean cascade, HttpServletResponse response) {
        if (cascade.booleanValue()) {
            this.repositoryService.deleteDeployment(deploymentId, true);
        } else {
            this.repositoryService.deleteDeployment(deploymentId);
        }
        response.setStatus(HttpStatus.NO_CONTENT.value());
    }
}

