/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.repository;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.activiti.engine.ActivitiObjectNotFoundException;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.repository.Deployment;
import org.activiti.rest.common.application.ContentTypeResolver;
import org.activiti.rest.service.api.RestResponseFactory;
import org.activiti.rest.service.api.repository.DeploymentResourceResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class DeploymentResourceResource {
    @Autowired
    protected RestResponseFactory restResponseFactory;
    @Autowired
    protected ContentTypeResolver contentTypeResolver;
    @Autowired
    protected RepositoryService repositoryService;

    @RequestMapping(value={"/repository/deployments/{deploymentId}/resources/**"}, method={RequestMethod.GET}, produces={"application/json"})
    public DeploymentResourceResponse getDeploymentResource(@PathVariable(value="deploymentId") String deploymentId, HttpServletRequest request) {
        Deployment deployment = (Deployment)this.repositoryService.createDeploymentQuery().deploymentId(deploymentId).singleResult();
        if (deployment == null) {
            throw new ActivitiObjectNotFoundException("Could not find a deployment with id '" + deploymentId + "'.");
        }
        String pathInfo = request.getPathInfo();
        String resourceName = pathInfo.replace("/repository/deployments/" + deploymentId + "/resources/", "");
        List resourceList = this.repositoryService.getDeploymentResourceNames(deploymentId);
        String serverRootUrl = request.getRequestURL().toString();
        serverRootUrl = serverRootUrl.substring(0, serverRootUrl.indexOf("/repository/deployments/"));
        if (resourceList.contains(resourceName)) {
            DeploymentResourceResponse response = this.restResponseFactory.createDeploymentResourceResponse(deploymentId, resourceName, this.contentTypeResolver.resolveContentType(resourceName), serverRootUrl);
            return response;
        }
        throw new ActivitiObjectNotFoundException("Could not find a resource with id '" + resourceName + "' in deployment '" + deploymentId + "'.");
    }
}

