/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.repository;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.activiti.engine.repository.Model;
import org.activiti.rest.service.api.repository.BaseModelResource;
import org.activiti.rest.service.api.repository.ModelRequest;
import org.activiti.rest.service.api.repository.ModelResponse;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ModelResource
extends BaseModelResource {
    @RequestMapping(value={"/repository/models/{modelId}"}, method={RequestMethod.GET}, produces={"application/json"})
    public ModelResponse getModel(@PathVariable String modelId, HttpServletRequest request) {
        Model model = this.getModelFromRequest(modelId);
        String serverRootUrl = request.getRequestURL().toString();
        serverRootUrl = serverRootUrl.substring(0, serverRootUrl.indexOf("/repository/models/"));
        return this.restResponseFactory.createModelResponse(model, serverRootUrl);
    }

    @RequestMapping(value={"/repository/models/{modelId}"}, method={RequestMethod.PUT}, produces={"application/json"})
    public ModelResponse updateModel(@PathVariable String modelId, @RequestBody ModelRequest modelRequest, HttpServletRequest request) {
        Model model = this.getModelFromRequest(modelId);
        if (modelRequest.isCategoryChanged()) {
            model.setCategory(modelRequest.getCategory());
        }
        if (modelRequest.isDeploymentChanged()) {
            model.setDeploymentId(modelRequest.getDeploymentId());
        }
        if (modelRequest.isKeyChanged()) {
            model.setKey(modelRequest.getKey());
        }
        if (modelRequest.isMetaInfoChanged()) {
            model.setMetaInfo(modelRequest.getMetaInfo());
        }
        if (modelRequest.isNameChanged()) {
            model.setName(modelRequest.getName());
        }
        if (modelRequest.isVersionChanged()) {
            model.setVersion(modelRequest.getVersion());
        }
        if (modelRequest.isTenantIdChanged()) {
            model.setTenantId(modelRequest.getTenantId());
        }
        this.repositoryService.saveModel(model);
        String serverRootUrl = request.getRequestURL().toString();
        serverRootUrl = serverRootUrl.substring(0, serverRootUrl.indexOf("/repository/models/"));
        return this.restResponseFactory.createModelResponse(model, serverRootUrl);
    }

    @RequestMapping(value={"/repository/models/{modelId}"}, method={RequestMethod.DELETE})
    public void deleteModel(@PathVariable String modelId, HttpServletResponse response) {
        Model model = this.getModelFromRequest(modelId);
        this.repositoryService.deleteModel(model.getId());
        response.setStatus(HttpStatus.NO_CONTENT.value());
    }
}

