/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.repository;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.impl.ProcessDefinitionQueryProperty;
import org.activiti.engine.query.Query;
import org.activiti.engine.query.QueryProperty;
import org.activiti.engine.repository.ProcessDefinitionQuery;
import org.activiti.rest.common.api.DataResponse;
import org.activiti.rest.service.api.RestResponseFactory;
import org.activiti.rest.service.api.repository.ProcessDefinitionsPaginateList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ProcessDefinitionCollectionResource {
    private static final Map<String, QueryProperty> properties = new HashMap<String, QueryProperty>();
    @Autowired
    protected RestResponseFactory restResponseFactory;
    @Autowired
    protected RepositoryService repositoryService;

    @RequestMapping(value={"/repository/process-definitions"}, method={RequestMethod.GET}, produces={"application/json"})
    public DataResponse getProcessDefinitions(@RequestParam Map<String, String> allRequestParams, HttpServletRequest request) {
        Boolean latest;
        Boolean suspended;
        ProcessDefinitionQuery processDefinitionQuery = this.repositoryService.createProcessDefinitionQuery();
        if (allRequestParams.containsKey("category")) {
            processDefinitionQuery.processDefinitionCategory(allRequestParams.get("category"));
        }
        if (allRequestParams.containsKey("categoryLike")) {
            processDefinitionQuery.processDefinitionCategoryLike(allRequestParams.get("categoryLike"));
        }
        if (allRequestParams.containsKey("categoryNotEquals")) {
            processDefinitionQuery.processDefinitionCategoryNotEquals(allRequestParams.get("categoryNotEquals"));
        }
        if (allRequestParams.containsKey("key")) {
            processDefinitionQuery.processDefinitionKey(allRequestParams.get("key"));
        }
        if (allRequestParams.containsKey("keyLike")) {
            processDefinitionQuery.processDefinitionKeyLike(allRequestParams.get("keyLike"));
        }
        if (allRequestParams.containsKey("name")) {
            processDefinitionQuery.processDefinitionName(allRequestParams.get("name"));
        }
        if (allRequestParams.containsKey("nameLike")) {
            processDefinitionQuery.processDefinitionNameLike(allRequestParams.get("nameLike"));
        }
        if (allRequestParams.containsKey("resourceName")) {
            processDefinitionQuery.processDefinitionResourceName(allRequestParams.get("resourceName"));
        }
        if (allRequestParams.containsKey("resourceNameLike")) {
            processDefinitionQuery.processDefinitionResourceNameLike(allRequestParams.get("resourceNameLike"));
        }
        if (allRequestParams.containsKey("version")) {
            processDefinitionQuery.processDefinitionVersion(Integer.valueOf(allRequestParams.get("version")));
        }
        if (allRequestParams.containsKey("suspended") && (suspended = Boolean.valueOf(allRequestParams.get("suspended"))) != null) {
            if (suspended.booleanValue()) {
                processDefinitionQuery.suspended();
            } else {
                processDefinitionQuery.active();
            }
        }
        if (allRequestParams.containsKey("latest") && (latest = Boolean.valueOf(allRequestParams.get("latest"))) != null && latest.booleanValue()) {
            processDefinitionQuery.latestVersion();
        }
        if (allRequestParams.containsKey("deploymentId")) {
            processDefinitionQuery.deploymentId(allRequestParams.get("deploymentId"));
        }
        if (allRequestParams.containsKey("startableByUser")) {
            processDefinitionQuery.startableByUser(allRequestParams.get("startableByUser"));
        }
        return new ProcessDefinitionsPaginateList(this.restResponseFactory, request.getRequestURL().toString().replace("/repository/process-definitions", "")).paginateList(allRequestParams, (Query)processDefinitionQuery, "name", properties);
    }

    static {
        properties.put("id", (QueryProperty)ProcessDefinitionQueryProperty.PROCESS_DEFINITION_ID);
        properties.put("key", (QueryProperty)ProcessDefinitionQueryProperty.PROCESS_DEFINITION_KEY);
        properties.put("category", (QueryProperty)ProcessDefinitionQueryProperty.PROCESS_DEFINITION_CATEGORY);
        properties.put("name", (QueryProperty)ProcessDefinitionQueryProperty.PROCESS_DEFINITION_NAME);
        properties.put("version", (QueryProperty)ProcessDefinitionQueryProperty.PROCESS_DEFINITION_VERSION);
        properties.put("deploymentId", (QueryProperty)ProcessDefinitionQueryProperty.DEPLOYMENT_ID);
    }
}

