/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.runtime.process;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.ActivitiObjectNotFoundException;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.impl.ExecutionQueryProperty;
import org.activiti.engine.query.Query;
import org.activiti.engine.query.QueryProperty;
import org.activiti.engine.runtime.Execution;
import org.activiti.engine.runtime.ExecutionQuery;
import org.activiti.rest.common.api.DataResponse;
import org.activiti.rest.service.api.RestResponseFactory;
import org.activiti.rest.service.api.engine.variable.QueryVariable;
import org.activiti.rest.service.api.engine.variable.RestVariable;
import org.activiti.rest.service.api.runtime.process.ExecutionActionRequest;
import org.activiti.rest.service.api.runtime.process.ExecutionPaginateList;
import org.activiti.rest.service.api.runtime.process.ExecutionQueryRequest;
import org.springframework.beans.factory.annotation.Autowired;

public class ExecutionBaseResource {
    private static Map<String, QueryProperty> allowedSortProperties = new HashMap<String, QueryProperty>();
    @Autowired
    protected RestResponseFactory restResponseFactory;
    @Autowired
    protected RuntimeService runtimeService;

    protected DataResponse getQueryResponse(ExecutionQueryRequest queryRequest, Map<String, String> requestParams, String serverRootUrl) {
        ExecutionQuery query = this.runtimeService.createExecutionQuery();
        if (queryRequest.getId() != null) {
            query.executionId(queryRequest.getId());
        }
        if (queryRequest.getProcessInstanceId() != null) {
            query.processInstanceId(queryRequest.getProcessInstanceId());
        }
        if (queryRequest.getProcessDefinitionKey() != null) {
            query.processDefinitionKey(queryRequest.getProcessDefinitionKey());
        }
        if (queryRequest.getProcessDefinitionId() != null) {
            query.processDefinitionId(queryRequest.getProcessDefinitionId());
        }
        if (queryRequest.getProcessBusinessKey() != null) {
            query.processInstanceBusinessKey(queryRequest.getProcessBusinessKey());
        }
        if (queryRequest.getActivityId() != null) {
            query.activityId(queryRequest.getActivityId());
        }
        if (queryRequest.getParentId() != null) {
            query.parentId(queryRequest.getParentId());
        }
        if (queryRequest.getMessageEventSubscriptionName() != null) {
            query.messageEventSubscriptionName(queryRequest.getMessageEventSubscriptionName());
        }
        if (queryRequest.getSignalEventSubscriptionName() != null) {
            query.signalEventSubscriptionName(queryRequest.getSignalEventSubscriptionName());
        }
        if (queryRequest.getVariables() != null) {
            this.addVariables(query, queryRequest.getVariables(), false);
        }
        if (queryRequest.getProcessInstanceVariables() != null) {
            this.addVariables(query, queryRequest.getProcessInstanceVariables(), true);
        }
        if (queryRequest.getTenantId() != null) {
            query.executionTenantId(queryRequest.getTenantId());
        }
        if (queryRequest.getTenantIdLike() != null) {
            query.executionTenantIdLike(queryRequest.getTenantIdLike());
        }
        if (Boolean.TRUE.equals(queryRequest.getWithoutTenantId())) {
            query.executionWithoutTenantId();
        }
        return new ExecutionPaginateList(this.restResponseFactory, serverRootUrl).paginateList(requestParams, queryRequest, (Query)query, "processInstanceId", allowedSortProperties);
    }

    protected void addVariables(ExecutionQuery processInstanceQuery, List<QueryVariable> variables, boolean process) {
        block6: for (QueryVariable variable : variables) {
            if (variable.getVariableOperation() == null) {
                throw new ActivitiIllegalArgumentException("Variable operation is missing for variable: " + variable.getName());
            }
            if (variable.getValue() == null) {
                throw new ActivitiIllegalArgumentException("Variable value is missing for variable: " + variable.getName());
            }
            boolean nameLess = variable.getName() == null;
            Object actualValue = this.restResponseFactory.getVariableValue(variable);
            if (nameLess && variable.getVariableOperation() != QueryVariable.QueryVariableOperation.EQUALS) {
                throw new ActivitiIllegalArgumentException("Value-only query (without a variable-name) is only supported when using 'equals' operation.");
            }
            switch (variable.getVariableOperation()) {
                case EQUALS: {
                    if (nameLess) {
                        if (process) {
                            processInstanceQuery.processVariableValueEquals(actualValue);
                            continue block6;
                        }
                        processInstanceQuery.variableValueEquals(actualValue);
                        continue block6;
                    }
                    if (process) {
                        processInstanceQuery.processVariableValueEquals(variable.getName(), actualValue);
                        continue block6;
                    }
                    processInstanceQuery.variableValueEquals(variable.getName(), actualValue);
                    continue block6;
                }
                case EQUALS_IGNORE_CASE: {
                    if (actualValue instanceof String) {
                        if (process) {
                            processInstanceQuery.processVariableValueEqualsIgnoreCase(variable.getName(), (String)actualValue);
                            continue block6;
                        }
                        processInstanceQuery.variableValueEqualsIgnoreCase(variable.getName(), (String)actualValue);
                        continue block6;
                    }
                    throw new ActivitiIllegalArgumentException("Only string variable values are supported when ignoring casing, but was: " + actualValue.getClass().getName());
                }
                case NOT_EQUALS: {
                    if (process) {
                        processInstanceQuery.processVariableValueNotEquals(variable.getName(), actualValue);
                        continue block6;
                    }
                    processInstanceQuery.variableValueNotEquals(variable.getName(), actualValue);
                    continue block6;
                }
                case NOT_EQUALS_IGNORE_CASE: {
                    if (actualValue instanceof String) {
                        if (process) {
                            processInstanceQuery.processVariableValueNotEqualsIgnoreCase(variable.getName(), (String)actualValue);
                            continue block6;
                        }
                        processInstanceQuery.variableValueNotEqualsIgnoreCase(variable.getName(), (String)actualValue);
                        continue block6;
                    }
                    throw new ActivitiIllegalArgumentException("Only string variable values are supported when ignoring casing, but was: " + actualValue.getClass().getName());
                }
            }
            throw new ActivitiIllegalArgumentException("Unsupported variable query operation: " + (Object)((Object)variable.getVariableOperation()));
        }
    }

    protected Execution getExecutionFromRequest(String executionId) {
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().executionId(executionId).singleResult();
        if (execution == null) {
            throw new ActivitiObjectNotFoundException("Could not find an execution with id '" + executionId + "'.", Execution.class);
        }
        return execution;
    }

    protected Map<String, Object> getVariablesToSet(ExecutionActionRequest actionRequest) {
        HashMap<String, Object> variablesToSet = new HashMap<String, Object>();
        for (RestVariable var : actionRequest.getVariables()) {
            if (var.getName() == null) {
                throw new ActivitiIllegalArgumentException("Variable name is required");
            }
            Object actualVariableValue = this.restResponseFactory.getVariableValue(var);
            variablesToSet.put(var.getName(), actualVariableValue);
        }
        return variablesToSet;
    }

    static {
        allowedSortProperties.put("processDefinitionId", (QueryProperty)ExecutionQueryProperty.PROCESS_DEFINITION_ID);
        allowedSortProperties.put("processDefinitionKey", (QueryProperty)ExecutionQueryProperty.PROCESS_DEFINITION_KEY);
        allowedSortProperties.put("processInstanceId", (QueryProperty)ExecutionQueryProperty.PROCESS_INSTANCE_ID);
        allowedSortProperties.put("tenantId", (QueryProperty)ExecutionQueryProperty.TENANT_ID);
    }
}

