/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.runtime.process;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.activiti.engine.runtime.Execution;
import org.activiti.rest.service.api.engine.variable.RestVariable;
import org.activiti.rest.service.api.runtime.process.BaseVariableCollectionResource;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ExecutionVariableCollectionResource
extends BaseVariableCollectionResource {
    @RequestMapping(value={"/runtime/executions/{executionId}/variables"}, method={RequestMethod.GET}, produces={"application/json"})
    public List<RestVariable> getVariables(@PathVariable String executionId, @RequestParam(value="scope", required=false) String scope, HttpServletRequest request) {
        Execution execution = this.getExecutionFromRequest(executionId);
        return this.processVariables(execution, scope, 2, this.getServerRootUrl(request));
    }

    @RequestMapping(value={"/runtime/executions/{executionId}/variables"}, method={RequestMethod.PUT}, produces={"application/json"})
    public Object createOrUpdateExecutionVariable(@PathVariable String executionId, HttpServletRequest request, HttpServletResponse response) {
        Execution execution = this.getExecutionFromRequest(executionId);
        return this.createExecutionVariable(execution, true, 2, this.getServerRootUrl(request), request, response);
    }

    @RequestMapping(value={"/runtime/executions/{executionId}/variables"}, method={RequestMethod.POST}, produces={"application/json"})
    public Object createExecutionVariable(@PathVariable String executionId, HttpServletRequest request, HttpServletResponse response) {
        Execution execution = this.getExecutionFromRequest(executionId);
        return this.createExecutionVariable(execution, false, 2, this.getServerRootUrl(request), request, response);
    }

    @RequestMapping(value={"/runtime/executions/{executionId}/variables"}, method={RequestMethod.DELETE})
    public void deleteLocalVariables(@PathVariable String executionId, HttpServletResponse response) {
        Execution execution = this.getExecutionFromRequest(executionId);
        this.deleteAllLocalVariables(execution, response);
    }

    protected String getServerRootUrl(HttpServletRequest request) {
        String serverRootUrl = request.getRequestURL().toString();
        serverRootUrl = serverRootUrl.substring(0, serverRootUrl.indexOf("/repository/executions/"));
        return serverRootUrl;
    }
}

