/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.runtime.process;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.ActivitiObjectNotFoundException;
import org.activiti.engine.runtime.Execution;
import org.activiti.rest.service.api.engine.variable.RestVariable;
import org.activiti.rest.service.api.runtime.process.BaseExecutionVariableResource;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ExecutionVariableDataResource
extends BaseExecutionVariableResource {
    @RequestMapping(value={"/runtime/executions/{executionId}/variables/{variableName}/data"}, method={RequestMethod.GET})
    @ResponseBody
    public byte[] getVariableData(@PathVariable(value="executionId") String executionId, @PathVariable(value="variableName") String variableName, @RequestParam(value="scope", required=false) String scope, HttpServletRequest request, HttpServletResponse response) {
        try {
            byte[] result = null;
            String serverRootUrl = request.getRequestURL().toString();
            serverRootUrl = serverRootUrl.substring(0, serverRootUrl.indexOf("/runtime/executions/"));
            Execution execution = this.getExecutionFromRequest(executionId);
            RestVariable variable = this.getVariableFromRequest(execution, variableName, scope, true, serverRootUrl);
            if ("binary".equals(variable.getType())) {
                result = (byte[])variable.getValue();
                response.setContentType("application/octet-stream");
            } else if ("serializable".equals(variable.getType())) {
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                ObjectOutputStream outputStream = new ObjectOutputStream(buffer);
                outputStream.writeObject(variable.getValue());
                outputStream.close();
                result = buffer.toByteArray();
                response.setContentType("application/x-java-serialized-object");
            } else {
                throw new ActivitiObjectNotFoundException("The variable does not have a binary data stream.", null);
            }
            return result;
        }
        catch (IOException ioe) {
            throw new ActivitiException("Error getting variable " + variableName, (Throwable)ioe);
        }
    }
}

