/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.runtime.process;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.ActivitiObjectNotFoundException;
import org.activiti.engine.HistoryService;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.rest.common.api.DataResponse;
import org.activiti.rest.service.api.engine.variable.RestVariable;
import org.activiti.rest.service.api.runtime.process.BaseProcessInstanceResource;
import org.activiti.rest.service.api.runtime.process.ProcessInstanceCreateRequest;
import org.activiti.rest.service.api.runtime.process.ProcessInstanceQueryRequest;
import org.activiti.rest.service.api.runtime.process.ProcessInstanceResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ProcessInstanceCollectionResource
extends BaseProcessInstanceResource {
    @Autowired
    protected HistoryService historyService;

    @RequestMapping(value={"/runtime/process-instances"}, method={RequestMethod.GET}, produces={"application/json"})
    public DataResponse getProcessInstances(@RequestParam Map<String, String> allRequestParams, HttpServletRequest request) {
        ProcessInstanceQueryRequest queryRequest = new ProcessInstanceQueryRequest();
        if (allRequestParams.containsKey("id")) {
            queryRequest.setProcessInstanceId(allRequestParams.get("id"));
        }
        if (allRequestParams.containsKey("processDefinitionKey")) {
            queryRequest.setProcessDefinitionKey(allRequestParams.get("processDefinitionKey"));
        }
        if (allRequestParams.containsKey("processDefinitionId")) {
            queryRequest.setProcessDefinitionId(allRequestParams.get("processDefinitionId"));
        }
        if (allRequestParams.containsKey("businessKey")) {
            queryRequest.setProcessBusinessKey(allRequestParams.get("businessKey"));
        }
        if (allRequestParams.containsKey("involvedUser")) {
            queryRequest.setInvolvedUser(allRequestParams.get("involvedUser"));
        }
        if (allRequestParams.containsKey("suspended")) {
            queryRequest.setSuspended(Boolean.valueOf(allRequestParams.get("suspended")));
        }
        if (allRequestParams.containsKey("superProcessInstanceId")) {
            queryRequest.setSuperProcessInstanceId(allRequestParams.get("superProcessInstanceId"));
        }
        if (allRequestParams.containsKey("subProcessInstanceId")) {
            queryRequest.setSubProcessInstanceId(allRequestParams.get("subProcessInstanceId"));
        }
        if (allRequestParams.containsKey("excludeSubprocesses")) {
            queryRequest.setExcludeSubprocesses(Boolean.valueOf(allRequestParams.get("excludeSubprocesses")));
        }
        if (allRequestParams.containsKey("includeProcessVariables")) {
            queryRequest.setIncludeProcessVariables(Boolean.valueOf(allRequestParams.get("includeProcessVariables")));
        }
        if (allRequestParams.containsKey("tenantId")) {
            queryRequest.setTenantId(allRequestParams.get("tenantId"));
        }
        if (allRequestParams.containsKey("tenantIdLike")) {
            queryRequest.setTenantIdLike(allRequestParams.get("tenantIdLike"));
        }
        if (allRequestParams.containsKey("withoutTenantId") && Boolean.valueOf(allRequestParams.get("withoutTenantId")).booleanValue()) {
            queryRequest.setWithoutTenantId(Boolean.TRUE);
        }
        return this.getQueryResponse(queryRequest, allRequestParams, request.getRequestURL().toString().replace("/runtime/process-instances", ""));
    }

    @RequestMapping(value={"/runtime/process-instances"}, method={RequestMethod.POST}, produces={"application/json"})
    public ProcessInstanceResponse createProcessInstance(@RequestBody ProcessInstanceCreateRequest request, HttpServletRequest httpRequest, HttpServletResponse response) {
        if (request.getProcessDefinitionId() == null && request.getProcessDefinitionKey() == null && request.getMessage() == null) {
            throw new ActivitiIllegalArgumentException("Either processDefinitionId, processDefinitionKey or message is required.");
        }
        int paramsSet = (request.getProcessDefinitionId() != null ? 1 : 0) + (request.getProcessDefinitionKey() != null ? 1 : 0) + (request.getMessage() != null ? 1 : 0);
        if (paramsSet > 1) {
            throw new ActivitiIllegalArgumentException("Only one of processDefinitionId, processDefinitionKey or message should be set.");
        }
        if (request.isCustomTenantSet() && request.getProcessDefinitionId() != null) {
            throw new ActivitiIllegalArgumentException("TenantId can only be used with either processDefinitionKey or message.");
        }
        HashMap<String, Object> startVariables = null;
        if (request.getVariables() != null) {
            startVariables = new HashMap<String, Object>();
            for (RestVariable variable : request.getVariables()) {
                if (variable.getName() == null) {
                    throw new ActivitiIllegalArgumentException("Variable name is required.");
                }
                startVariables.put(variable.getName(), this.restResponseFactory.getVariableValue(variable));
            }
        }
        try {
            ProcessInstance instance = null;
            instance = request.getProcessDefinitionId() != null ? this.runtimeService.startProcessInstanceById(request.getProcessDefinitionId(), request.getBusinessKey(), startVariables) : (request.getProcessDefinitionKey() != null ? (request.isCustomTenantSet() ? this.runtimeService.startProcessInstanceByKeyAndTenantId(request.getProcessDefinitionKey(), request.getBusinessKey(), startVariables, request.getTenantId()) : this.runtimeService.startProcessInstanceByKey(request.getProcessDefinitionKey(), request.getBusinessKey(), startVariables)) : (request.isCustomTenantSet() ? this.runtimeService.startProcessInstanceByMessageAndTenantId(request.getMessage(), request.getBusinessKey(), startVariables, request.getTenantId()) : this.runtimeService.startProcessInstanceByMessage(request.getMessage(), request.getBusinessKey(), startVariables)));
            response.setStatus(HttpStatus.CREATED.value());
            String serverRootUrl = httpRequest.getRequestURL().toString().replace("/runtime/process-instances", "");
            if (request.getReturnVariables()) {
                Map runtimeVariableMap = null;
                List historicVariableList = null;
                if (instance.isEnded()) {
                    historicVariableList = this.historyService.createHistoricVariableInstanceQuery().processInstanceId(instance.getId()).list();
                } else {
                    runtimeVariableMap = this.runtimeService.getVariables(instance.getId());
                }
                return this.restResponseFactory.createProcessInstanceResponse(instance, true, runtimeVariableMap, historicVariableList, serverRootUrl);
            }
            return this.restResponseFactory.createProcessInstanceResponse(instance, serverRootUrl);
        }
        catch (ActivitiObjectNotFoundException aonfe) {
            throw new ActivitiIllegalArgumentException(aonfe.getMessage(), (Throwable)aonfe);
        }
    }
}

