/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.runtime.process;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.IdentityLink;
import org.activiti.rest.service.api.engine.RestIdentityLink;
import org.activiti.rest.service.api.runtime.process.BaseProcessInstanceResource;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ProcessInstanceIdentityLinkCollectionResource
extends BaseProcessInstanceResource {
    @RequestMapping(value={"/runtime/process-instances/{processInstanceId}/identitylinks"}, method={RequestMethod.GET}, produces={"application/json"})
    public List<RestIdentityLink> getIdentityLinks(@PathVariable String processInstanceId, HttpServletRequest request) {
        ArrayList<RestIdentityLink> result = new ArrayList<RestIdentityLink>();
        ProcessInstance processInstance = this.getProcessInstanceFromRequest(processInstanceId);
        String serverRootUrl = request.getRequestURL().toString();
        serverRootUrl = serverRootUrl.substring(0, serverRootUrl.indexOf("/runtime/process-instances/"));
        List identityLinks = this.runtimeService.getIdentityLinksForProcessInstance(processInstance.getId());
        for (IdentityLink link : identityLinks) {
            result.add(this.restResponseFactory.createRestIdentityLink(link, serverRootUrl));
        }
        return result;
    }

    @RequestMapping(value={"/runtime/process-instances/{processInstanceId}/identitylinks"}, method={RequestMethod.POST}, produces={"application/json"})
    public RestIdentityLink createIdentityLink(@PathVariable String processInstanceId, @RequestBody RestIdentityLink identityLink, HttpServletRequest request, HttpServletResponse response) {
        ProcessInstance processInstance = this.getProcessInstanceFromRequest(processInstanceId);
        if (identityLink.getGroup() != null) {
            throw new ActivitiIllegalArgumentException("Only user identity links are supported on a process instance.");
        }
        if (identityLink.getUser() == null) {
            throw new ActivitiIllegalArgumentException("The user is required.");
        }
        if (identityLink.getType() == null) {
            throw new ActivitiIllegalArgumentException("The identity link type is required.");
        }
        this.runtimeService.addUserIdentityLink(processInstance.getId(), identityLink.getUser(), identityLink.getType());
        response.setStatus(HttpStatus.CREATED.value());
        String serverRootUrl = request.getRequestURL().toString();
        serverRootUrl = serverRootUrl.substring(0, serverRootUrl.indexOf("/runtime/process-instances/"));
        return this.restResponseFactory.createRestIdentityLink(identityLink.getType(), identityLink.getUser(), identityLink.getGroup(), null, null, processInstance.getId(), serverRootUrl);
    }
}

