/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.runtime.task;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.activiti.engine.ActivitiObjectNotFoundException;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.task.Attachment;
import org.activiti.engine.task.Comment;
import org.activiti.engine.task.Task;
import org.activiti.rest.service.api.engine.AttachmentResponse;
import org.activiti.rest.service.api.runtime.task.TaskBaseResource;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class TaskAttachmentResource
extends TaskBaseResource {
    @RequestMapping(value={"/runtime/tasks/{taskId}/attachments/{attachmentId}"}, method={RequestMethod.GET}, produces={"application/json"})
    public AttachmentResponse getAttachment(@PathVariable(value="taskId") String taskId, @PathVariable(value="attachmentId") String attachmentId, HttpServletRequest request) {
        HistoricTaskInstance task = this.getHistoricTaskFromRequest(taskId);
        Attachment attachment = this.taskService.getAttachment(attachmentId);
        if (attachment == null || !task.getId().equals(attachment.getTaskId())) {
            throw new ActivitiObjectNotFoundException("Task '" + task.getId() + "' doesn't have an attachment with id '" + attachmentId + "'.", Comment.class);
        }
        String serverRootUrl = request.getRequestURL().toString();
        serverRootUrl = serverRootUrl.substring(0, serverRootUrl.indexOf("/runtime/tasks/"));
        return this.restResponseFactory.createAttachmentResponse(attachment, serverRootUrl);
    }

    @RequestMapping(value={"/runtime/tasks/{taskId}/attachments/{attachmentId}"}, method={RequestMethod.DELETE})
    public void deleteAttachment(@PathVariable(value="taskId") String taskId, @PathVariable(value="attachmentId") String attachmentId, HttpServletResponse response) {
        Task task = this.getTaskFromRequest(taskId);
        Attachment attachment = this.taskService.getAttachment(attachmentId);
        if (attachment == null || !task.getId().equals(attachment.getTaskId())) {
            throw new ActivitiObjectNotFoundException("Task '" + task.getId() + "' doesn't have an attachment with id '" + attachmentId + "'.", Comment.class);
        }
        this.taskService.deleteAttachment(attachmentId);
        response.setStatus(HttpStatus.NO_CONTENT.value());
    }
}

