/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.runtime.task;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.task.Comment;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskQuery;
import org.activiti.rest.service.api.engine.CommentRequest;
import org.activiti.rest.service.api.engine.CommentResponse;
import org.activiti.rest.service.api.runtime.task.TaskBaseResource;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class TaskCommentCollectionResource
extends TaskBaseResource {
    @RequestMapping(value={"/runtime/tasks/{taskId}/comments"}, method={RequestMethod.GET}, produces={"application/json"})
    public List<CommentResponse> getComments(@PathVariable String taskId, HttpServletRequest request) {
        ArrayList<CommentResponse> result = new ArrayList<CommentResponse>();
        HistoricTaskInstance task = this.getHistoricTaskFromRequest(taskId);
        String serverRootUrl = request.getRequestURL().toString();
        serverRootUrl = serverRootUrl.substring(0, serverRootUrl.indexOf("/runtime/tasks/"));
        for (Comment comment : this.taskService.getTaskComments(task.getId())) {
            result.add(this.restResponseFactory.createRestComment(comment, serverRootUrl));
        }
        return result;
    }

    @RequestMapping(value={"/runtime/tasks/{taskId}/comments"}, method={RequestMethod.POST}, produces={"application/json"})
    public CommentResponse createComment(@PathVariable String taskId, @RequestBody CommentRequest comment, HttpServletRequest request, HttpServletResponse response) {
        Task task = this.getTaskFromRequest(taskId);
        if (comment.getMessage() == null) {
            throw new ActivitiIllegalArgumentException("Comment text is required.");
        }
        String processInstanceId = null;
        if (comment.isSaveProcessInstanceId()) {
            Task taskEntity = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(task.getId())).singleResult();
            processInstanceId = taskEntity.getProcessInstanceId();
        }
        Comment createdComment = this.taskService.addComment(task.getId(), processInstanceId, comment.getMessage());
        response.setStatus(HttpStatus.CREATED.value());
        String serverRootUrl = request.getRequestURL().toString();
        serverRootUrl = serverRootUrl.substring(0, serverRootUrl.indexOf("/runtime/tasks/"));
        return this.restResponseFactory.createRestComment(createdComment, serverRootUrl);
    }
}

