/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.runtime.task;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.activiti.engine.ActivitiObjectNotFoundException;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.task.Comment;
import org.activiti.engine.task.Task;
import org.activiti.rest.service.api.engine.CommentResponse;
import org.activiti.rest.service.api.runtime.task.TaskBaseResource;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class TaskCommentResource
extends TaskBaseResource {
    @RequestMapping(value={"/runtime/tasks/{taskId}/comments/{commentId}"}, method={RequestMethod.GET}, produces={"application/json"})
    public CommentResponse getComment(@PathVariable(value="taskId") String taskId, @PathVariable(value="commentId") String commentId, HttpServletRequest request) {
        HistoricTaskInstance task = this.getHistoricTaskFromRequest(taskId);
        Comment comment = this.taskService.getComment(commentId);
        if (comment == null || !task.getId().equals(comment.getTaskId())) {
            throw new ActivitiObjectNotFoundException("Task '" + task.getId() + "' doesn't have a comment with id '" + commentId + "'.", Comment.class);
        }
        String serverRootUrl = request.getRequestURL().toString();
        serverRootUrl = serverRootUrl.substring(0, serverRootUrl.indexOf("/runtime/tasks/"));
        return this.restResponseFactory.createRestComment(comment, serverRootUrl);
    }

    @RequestMapping(value={"/runtime/tasks/{taskId}/comments/{commentId}"}, method={RequestMethod.DELETE})
    public void deleteComment(@PathVariable(value="taskId") String taskId, @PathVariable(value="commentId") String commentId, HttpServletResponse response) {
        Task task = this.getTaskFromRequest(taskId);
        Comment comment = this.taskService.getComment(commentId);
        if (comment == null || comment.getTaskId() == null || !comment.getTaskId().equals(task.getId())) {
            throw new ActivitiObjectNotFoundException("Task '" + task.getId() + "' doesn't have a comment with id '" + commentId + "'.", Comment.class);
        }
        this.taskService.deleteComment(commentId);
        response.setStatus(HttpStatus.NO_CONTENT.value());
    }
}

