/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.runtime.task;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.task.IdentityLink;
import org.activiti.engine.task.Task;
import org.activiti.rest.service.api.engine.RestIdentityLink;
import org.activiti.rest.service.api.runtime.task.TaskBaseResource;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class TaskIdentityLinkFamilyResource
extends TaskBaseResource {
    @RequestMapping(value={"/runtime/tasks/{taskId}/identitylinks/{family}"}, method={RequestMethod.GET}, produces={"application/json"})
    public List<RestIdentityLink> getIdentityLinksForFamily(@PathVariable(value="taskId") String taskId, @PathVariable(value="family") String family, HttpServletRequest request) {
        Task task = this.getTaskFromRequest(taskId);
        if (family == null || !"groups".equals(family) && !"users".equals(family)) {
            throw new ActivitiIllegalArgumentException("Identity link family should be 'users' or 'groups'.");
        }
        boolean isUser = family.equals("users");
        ArrayList<RestIdentityLink> results = new ArrayList<RestIdentityLink>();
        String serverRootUrl = request.getRequestURL().toString();
        serverRootUrl = serverRootUrl.substring(0, serverRootUrl.indexOf("/runtime/tasks/"));
        List allLinks = this.taskService.getIdentityLinksForTask(task.getId());
        for (IdentityLink link : allLinks) {
            boolean match = false;
            if (isUser) {
                match = link.getUserId() != null;
            } else {
                boolean bl = match = link.getGroupId() != null;
            }
            if (!match) continue;
            results.add(this.restResponseFactory.createRestIdentityLink(link, serverRootUrl));
        }
        return results;
    }
}

