/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.runtime.task;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.ActivitiObjectNotFoundException;
import org.activiti.engine.task.IdentityLink;
import org.activiti.engine.task.Task;
import org.activiti.rest.service.api.engine.RestIdentityLink;
import org.activiti.rest.service.api.runtime.task.TaskBaseResource;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class TaskIdentityLinkResource
extends TaskBaseResource {
    @RequestMapping(value={"/runtime/tasks/{taskId}/identitylinks/{family}/{identityId}/{type}"}, method={RequestMethod.GET}, produces={"application/json"})
    public RestIdentityLink getIdentityLink(@PathVariable(value="taskId") String taskId, @PathVariable(value="family") String family, @PathVariable(value="identityId") String identityId, @PathVariable(value="type") String type, HttpServletRequest request) {
        Task task = this.getTaskFromRequest(taskId);
        this.validateIdentityLinkArguments(family, identityId, type);
        IdentityLink link = this.getIdentityLink(family, identityId, type, task.getId());
        String serverRootUrl = request.getRequestURL().toString();
        serverRootUrl = serverRootUrl.substring(0, serverRootUrl.indexOf("/runtime/tasks/"));
        return this.restResponseFactory.createRestIdentityLink(link, serverRootUrl);
    }

    @RequestMapping(value={"/runtime/tasks/{taskId}/identitylinks/{family}/{identityId}/{type}"}, method={RequestMethod.DELETE})
    public void deleteIdentityLink(@PathVariable(value="taskId") String taskId, @PathVariable(value="family") String family, @PathVariable(value="identityId") String identityId, @PathVariable(value="type") String type, HttpServletResponse response) {
        Task task = this.getTaskFromRequest(taskId);
        this.validateIdentityLinkArguments(family, identityId, type);
        this.getIdentityLink(family, identityId, type, task.getId());
        if ("users".equals(family)) {
            this.taskService.deleteUserIdentityLink(task.getId(), identityId, type);
        } else {
            this.taskService.deleteGroupIdentityLink(task.getId(), identityId, type);
        }
        response.setStatus(HttpStatus.NO_CONTENT.value());
    }

    protected void validateIdentityLinkArguments(String family, String identityId, String type) {
        if (family == null || !"groups".equals(family) && !"users".equals(family)) {
            throw new ActivitiIllegalArgumentException("Identity link family should be 'users' or 'groups'.");
        }
        if (identityId == null) {
            throw new ActivitiIllegalArgumentException("IdentityId is required.");
        }
        if (type == null) {
            throw new ActivitiIllegalArgumentException("Type is required.");
        }
    }

    protected IdentityLink getIdentityLink(String family, String identityId, String type, String taskId) {
        boolean isUser = family.equals("users");
        List allLinks = this.taskService.getIdentityLinksForTask(taskId);
        for (IdentityLink link : allLinks) {
            boolean rightIdentity = false;
            rightIdentity = isUser ? identityId.equals(link.getUserId()) : identityId.equals(link.getGroupId());
            if (!rightIdentity || !link.getType().equals(type)) continue;
            return link;
        }
        throw new ActivitiObjectNotFoundException("Could not find the requested identity link.", IdentityLink.class);
    }
}

