/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.runtime.task;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.task.Task;
import org.activiti.rest.exception.ActivitiConflictException;
import org.activiti.rest.service.api.engine.variable.RestVariable;
import org.activiti.rest.service.api.runtime.task.TaskVariableBaseResource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@RestController
public class TaskVariableCollectionResource
extends TaskVariableBaseResource {
    @Autowired
    protected ObjectMapper objectMapper;

    @RequestMapping(value={"/runtime/tasks/{taskId}/variables"}, method={RequestMethod.GET}, produces={"application/json"})
    public List<RestVariable> getVariables(@PathVariable String taskId, @RequestParam(value="scope", required=false) String scope, HttpServletRequest request) {
        ArrayList<RestVariable> result = new ArrayList<RestVariable>();
        HashMap<String, RestVariable> variableMap = new HashMap<String, RestVariable>();
        Task task = this.getTaskFromRequest(taskId);
        String serverRootUrl = request.getRequestURL().toString();
        serverRootUrl = serverRootUrl.substring(0, serverRootUrl.indexOf("/runtime/tasks/"));
        RestVariable.RestVariableScope variableScope = RestVariable.getScopeFromString(scope);
        if (variableScope == null) {
            this.addLocalVariables(task, variableMap, serverRootUrl);
            this.addGlobalVariables(task, variableMap, serverRootUrl);
        } else if (variableScope == RestVariable.RestVariableScope.GLOBAL) {
            this.addGlobalVariables(task, variableMap, serverRootUrl);
        } else if (variableScope == RestVariable.RestVariableScope.LOCAL) {
            this.addLocalVariables(task, variableMap, serverRootUrl);
        }
        result.addAll(variableMap.values());
        return result;
    }

    @RequestMapping(value={"/runtime/tasks/{taskId}/variables"}, method={RequestMethod.POST}, produces={"application/json"})
    public Object createTaskVariable(@PathVariable String taskId, HttpServletRequest request, HttpServletResponse response) {
        Task task = this.getTaskFromRequest(taskId);
        String serverRootUrl = request.getRequestURL().toString();
        serverRootUrl = serverRootUrl.substring(0, serverRootUrl.indexOf("/runtime/tasks/"));
        Object result = null;
        if (request instanceof MultipartHttpServletRequest) {
            result = this.setBinaryVariable((MultipartHttpServletRequest)request, task, true, serverRootUrl);
        } else {
            ArrayList<RestVariable> inputVariables = new ArrayList<RestVariable>();
            ArrayList<RestVariable> resultVariables = new ArrayList<RestVariable>();
            result = resultVariables;
            try {
                List variableObjects = (List)this.objectMapper.readValue((InputStream)request.getInputStream(), List.class);
                for (Object restObject : variableObjects) {
                    RestVariable restVariable = (RestVariable)this.objectMapper.convertValue(restObject, RestVariable.class);
                    inputVariables.add(restVariable);
                }
            }
            catch (Exception e) {
                throw new ActivitiIllegalArgumentException("Failed to serialize to a RestVariable instance", (Throwable)e);
            }
            if (inputVariables == null || inputVariables.size() == 0) {
                throw new ActivitiIllegalArgumentException("Request didn't contain a list of variables to create.");
            }
            RestVariable.RestVariableScope sharedScope = null;
            RestVariable.RestVariableScope varScope = null;
            HashMap<String, Object> variablesToSet = new HashMap<String, Object>();
            for (RestVariable var : inputVariables) {
                varScope = var.getVariableScope();
                if (var.getName() == null) {
                    throw new ActivitiIllegalArgumentException("Variable name is required");
                }
                if (varScope == null) {
                    varScope = RestVariable.RestVariableScope.LOCAL;
                }
                if (sharedScope == null) {
                    sharedScope = varScope;
                }
                if (varScope != sharedScope) {
                    throw new ActivitiIllegalArgumentException("Only allowed to update multiple variables in the same scope.");
                }
                if (this.hasVariableOnScope(task, var.getName(), varScope)) {
                    throw new ActivitiConflictException("Variable '" + var.getName() + "' is already present on task '" + task.getId() + "'.");
                }
                Object actualVariableValue = this.restResponseFactory.getVariableValue(var);
                variablesToSet.put(var.getName(), actualVariableValue);
                resultVariables.add(this.restResponseFactory.createRestVariable(var.getName(), actualVariableValue, varScope, task.getId(), 1, false, serverRootUrl));
            }
            if (!variablesToSet.isEmpty()) {
                if (sharedScope == RestVariable.RestVariableScope.LOCAL) {
                    this.taskService.setVariablesLocal(task.getId(), variablesToSet);
                } else if (task.getExecutionId() != null) {
                    this.runtimeService.setVariables(task.getExecutionId(), variablesToSet);
                } else {
                    throw new ActivitiIllegalArgumentException("Cannot set global variables on task '" + task.getId() + "', task is not part of process.");
                }
            }
        }
        response.setStatus(HttpStatus.CREATED.value());
        return result;
    }

    @RequestMapping(value={"/runtime/tasks/{taskId}/variables"}, method={RequestMethod.DELETE})
    public void deleteAllLocalTaskVariables(@PathVariable String taskId, HttpServletResponse response) {
        Task task = this.getTaskFromRequest(taskId);
        Set currentVariables = this.taskService.getVariablesLocal(task.getId()).keySet();
        this.taskService.removeVariablesLocal(task.getId(), currentVariables);
        response.setStatus(HttpStatus.NO_CONTENT.value());
    }

    protected void addGlobalVariables(Task task, Map<String, RestVariable> variableMap, String serverRootUrl) {
        if (task.getExecutionId() != null) {
            Map rawVariables = this.runtimeService.getVariables(task.getExecutionId());
            List<RestVariable> globalVariables = this.restResponseFactory.createRestVariables(rawVariables, task.getId(), 1, RestVariable.RestVariableScope.GLOBAL, serverRootUrl);
            for (RestVariable var : globalVariables) {
                if (variableMap.containsKey(var.getName())) continue;
                variableMap.put(var.getName(), var);
            }
        }
    }

    protected void addLocalVariables(Task task, Map<String, RestVariable> variableMap, String serverRootUrl) {
        Map rawVariables = this.taskService.getVariablesLocal(task.getId());
        List<RestVariable> localVariables = this.restResponseFactory.createRestVariables(rawVariables, task.getId(), 1, RestVariable.RestVariableScope.LOCAL, serverRootUrl);
        for (RestVariable var : localVariables) {
            variableMap.put(var.getName(), var);
        }
    }
}

