/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.runtime.task;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.InputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.ActivitiObjectNotFoundException;
import org.activiti.engine.impl.persistence.entity.VariableInstanceEntity;
import org.activiti.engine.task.Task;
import org.activiti.rest.service.api.engine.variable.RestVariable;
import org.activiti.rest.service.api.runtime.task.TaskVariableBaseResource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@RestController
public class TaskVariableResource
extends TaskVariableBaseResource {
    @Autowired
    protected ObjectMapper objectMapper;

    @RequestMapping(value={"/runtime/tasks/{taskId}/variables/{variableName}"}, method={RequestMethod.GET}, produces={"application/json"})
    public RestVariable getVariable(@PathVariable(value="taskId") String taskId, @PathVariable(value="variableName") String variableName, @RequestParam(value="scope", required=false) String scope, HttpServletRequest request, HttpServletResponse response) {
        String serverRootUrl = request.getRequestURL().toString();
        serverRootUrl = serverRootUrl.substring(0, serverRootUrl.indexOf("/runtime/tasks/"));
        return this.getVariableFromRequest(taskId, variableName, scope, false, serverRootUrl);
    }

    @RequestMapping(value={"/runtime/tasks/{taskId}/variables/{variableName}"}, method={RequestMethod.PUT}, produces={"application/json"})
    public RestVariable updateVariable(@PathVariable(value="taskId") String taskId, @PathVariable(value="variableName") String variableName, @RequestParam(value="scope", required=false) String scope, HttpServletRequest request) {
        Task task = this.getTaskFromRequest(taskId);
        String serverRootUrl = request.getRequestURL().toString();
        serverRootUrl = serverRootUrl.substring(0, serverRootUrl.indexOf("/runtime/tasks/"));
        RestVariable result = null;
        if (request instanceof MultipartHttpServletRequest) {
            result = this.setBinaryVariable((MultipartHttpServletRequest)request, task, false, serverRootUrl);
            if (!result.getName().equals(variableName)) {
                throw new ActivitiIllegalArgumentException("Variable name in the body should be equal to the name used in the requested URL.");
            }
        } else {
            RestVariable restVariable = null;
            try {
                restVariable = (RestVariable)this.objectMapper.readValue((InputStream)request.getInputStream(), RestVariable.class);
            }
            catch (Exception e) {
                throw new ActivitiIllegalArgumentException("Error converting request body to RestVariable instance", (Throwable)e);
            }
            if (restVariable == null) {
                throw new ActivitiException("Invalid body was supplied");
            }
            if (!restVariable.getName().equals(variableName)) {
                throw new ActivitiIllegalArgumentException("Variable name in the body should be equal to the name used in the requested URL.");
            }
            result = this.setSimpleVariable(restVariable, task, false, serverRootUrl);
        }
        return result;
    }

    @RequestMapping(value={"/runtime/tasks/{taskId}/variables/{variableName}"}, method={RequestMethod.DELETE})
    public void deleteVariable(@PathVariable(value="taskId") String taskId, @PathVariable(value="variableName") String variableName, @RequestParam(value="scope", required=false) String scopeString, HttpServletResponse response) {
        Task task = this.getTaskFromRequest(taskId);
        RestVariable.RestVariableScope scope = RestVariable.RestVariableScope.LOCAL;
        if (scopeString != null) {
            scope = RestVariable.getScopeFromString(scopeString);
        }
        if (!this.hasVariableOnScope(task, variableName, scope)) {
            throw new ActivitiObjectNotFoundException("Task '" + task.getId() + "' doesn't have a variable '" + variableName + "' in scope " + scope.name().toLowerCase(), VariableInstanceEntity.class);
        }
        if (scope == RestVariable.RestVariableScope.LOCAL) {
            this.taskService.removeVariableLocal(task.getId(), variableName);
        } else {
            this.runtimeService.removeVariable(task.getExecutionId(), variableName);
        }
        response.setStatus(HttpStatus.NO_CONTENT.value());
    }
}

