/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.history;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.HistoryService;
import org.activiti.engine.history.HistoricVariableInstanceQuery;
import org.activiti.engine.impl.HistoricVariableInstanceQueryProperty;
import org.activiti.engine.query.Query;
import org.activiti.engine.query.QueryProperty;
import org.activiti.rest.common.api.DataResponse;
import org.activiti.rest.service.api.RestResponseFactory;
import org.activiti.rest.service.api.engine.variable.QueryVariable;
import org.activiti.rest.service.api.history.HistoricVariableInstancePaginateList;
import org.activiti.rest.service.api.history.HistoricVariableInstanceQueryRequest;
import org.springframework.beans.factory.annotation.Autowired;

public class HistoricVariableInstanceBaseResource {
    private static Map<String, QueryProperty> allowedSortProperties = new HashMap<String, QueryProperty>();
    @Autowired
    protected RestResponseFactory restResponseFactory;
    @Autowired
    protected HistoryService historyService;

    protected DataResponse getQueryResponse(HistoricVariableInstanceQueryRequest queryRequest, Map<String, String> allRequestParams) {
        HistoricVariableInstanceQuery query = this.historyService.createHistoricVariableInstanceQuery();
        if (queryRequest.getExcludeTaskVariables() != null && queryRequest.getExcludeTaskVariables().booleanValue()) {
            query.excludeTaskVariables();
        }
        if (queryRequest.getTaskId() != null) {
            query.taskId(queryRequest.getTaskId());
        }
        if (queryRequest.getExecutionId() != null) {
            query.executionId(queryRequest.getExecutionId());
        }
        if (queryRequest.getProcessInstanceId() != null) {
            query.processInstanceId(queryRequest.getProcessInstanceId());
        }
        if (queryRequest.getVariableName() != null) {
            query.variableName(queryRequest.getVariableName());
        }
        if (queryRequest.getVariableNameLike() != null) {
            query.variableNameLike(queryRequest.getVariableNameLike());
        }
        if (queryRequest.getVariables() != null) {
            this.addVariables(query, queryRequest.getVariables());
        }
        return new HistoricVariableInstancePaginateList(this.restResponseFactory).paginateList(allRequestParams, (Query)query, "variableName", allowedSortProperties);
    }

    protected void addVariables(HistoricVariableInstanceQuery variableInstanceQuery, List<QueryVariable> variables) {
        block3: for (QueryVariable variable : variables) {
            if (variable.getVariableOperation() == null) {
                throw new ActivitiIllegalArgumentException("Variable operation is missing for variable: " + variable.getName());
            }
            if (variable.getValue() == null) {
                throw new ActivitiIllegalArgumentException("Variable value is missing for variable: " + variable.getName());
            }
            boolean nameLess = variable.getName() == null;
            Object actualValue = this.restResponseFactory.getVariableValue(variable);
            if (nameLess) {
                throw new ActivitiIllegalArgumentException("Value-only query (without a variable-name) is not supported");
            }
            switch (variable.getVariableOperation()) {
                case EQUALS: {
                    variableInstanceQuery.variableValueEquals(variable.getName(), actualValue);
                    continue block3;
                }
            }
            throw new ActivitiIllegalArgumentException("Unsupported variable query operation: " + (Object)((Object)variable.getVariableOperation()));
        }
    }

    static {
        allowedSortProperties.put("processInstanceId", (QueryProperty)HistoricVariableInstanceQueryProperty.PROCESS_INSTANCE_ID);
        allowedSortProperties.put("variableName", (QueryProperty)HistoricVariableInstanceQueryProperty.VARIABLE_NAME);
    }
}

