/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.repository;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.activiti.engine.impl.ModelQueryProperty;
import org.activiti.engine.query.Query;
import org.activiti.engine.query.QueryProperty;
import org.activiti.engine.repository.Model;
import org.activiti.engine.repository.ModelQuery;
import org.activiti.rest.common.api.DataResponse;
import org.activiti.rest.service.api.repository.BaseModelResource;
import org.activiti.rest.service.api.repository.ModelRequest;
import org.activiti.rest.service.api.repository.ModelResponse;
import org.activiti.rest.service.api.repository.ModelsPaginateList;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ModelCollectionResource
extends BaseModelResource {
    private static Map<String, QueryProperty> allowedSortProperties = new HashMap<String, QueryProperty>();

    @RequestMapping(value={"/repository/models"}, method={RequestMethod.GET}, produces={"application/json"})
    public DataResponse getModels(@RequestParam Map<String, String> allRequestParams, HttpServletRequest request) {
        boolean withoutTenantId;
        boolean isLatestVersion;
        ModelQuery modelQuery = this.repositoryService.createModelQuery();
        if (allRequestParams.containsKey("id")) {
            modelQuery.modelId(allRequestParams.get("id"));
        }
        if (allRequestParams.containsKey("category")) {
            modelQuery.modelCategory(allRequestParams.get("category"));
        }
        if (allRequestParams.containsKey("categoryLike")) {
            modelQuery.modelCategoryLike(allRequestParams.get("categoryLike"));
        }
        if (allRequestParams.containsKey("categoryNotEquals")) {
            modelQuery.modelCategoryNotEquals(allRequestParams.get("categoryNotEquals"));
        }
        if (allRequestParams.containsKey("name")) {
            modelQuery.modelName(allRequestParams.get("name"));
        }
        if (allRequestParams.containsKey("nameLike")) {
            modelQuery.modelNameLike(allRequestParams.get("nameLike"));
        }
        if (allRequestParams.containsKey("key")) {
            modelQuery.modelKey(allRequestParams.get("key"));
        }
        if (allRequestParams.containsKey("version")) {
            modelQuery.modelVersion(Integer.valueOf(allRequestParams.get("version")));
        }
        if (allRequestParams.containsKey("latestVersion") && (isLatestVersion = Boolean.valueOf(allRequestParams.get("latestVersion")).booleanValue())) {
            modelQuery.latestVersion();
        }
        if (allRequestParams.containsKey("deploymentId")) {
            modelQuery.deploymentId(allRequestParams.get("deploymentId"));
        }
        if (allRequestParams.containsKey("deployed")) {
            boolean isDeployed = Boolean.valueOf(allRequestParams.get("deployed"));
            if (isDeployed) {
                modelQuery.deployed();
            } else {
                modelQuery.notDeployed();
            }
        }
        if (allRequestParams.containsKey("tenantId")) {
            modelQuery.modelTenantId(allRequestParams.get("tenantId"));
        }
        if (allRequestParams.containsKey("tenantIdLike")) {
            modelQuery.modelTenantIdLike(allRequestParams.get("tenantIdLike"));
        }
        if (allRequestParams.containsKey("withoutTenantId") && (withoutTenantId = Boolean.valueOf(allRequestParams.get("withoutTenantId")).booleanValue())) {
            modelQuery.modelWithoutTenantId();
        }
        return new ModelsPaginateList(this.restResponseFactory).paginateList(allRequestParams, (Query)modelQuery, "id", allowedSortProperties);
    }

    @RequestMapping(value={"/repository/models"}, method={RequestMethod.POST}, produces={"application/json"})
    public ModelResponse createModel(@RequestBody ModelRequest modelRequest, HttpServletRequest request, HttpServletResponse response) {
        Model model = this.repositoryService.newModel();
        model.setCategory(modelRequest.getCategory());
        model.setDeploymentId(modelRequest.getDeploymentId());
        model.setKey(modelRequest.getKey());
        model.setMetaInfo(modelRequest.getMetaInfo());
        model.setName(modelRequest.getName());
        model.setVersion(modelRequest.getVersion());
        model.setTenantId(modelRequest.getTenantId());
        this.repositoryService.saveModel(model);
        response.setStatus(HttpStatus.CREATED.value());
        return this.restResponseFactory.createModelResponse(model);
    }

    static {
        allowedSortProperties.put("id", (QueryProperty)ModelQueryProperty.MODEL_ID);
        allowedSortProperties.put("category", (QueryProperty)ModelQueryProperty.MODEL_CATEGORY);
        allowedSortProperties.put("createTime", (QueryProperty)ModelQueryProperty.MODEL_CREATE_TIME);
        allowedSortProperties.put("key", (QueryProperty)ModelQueryProperty.MODEL_KEY);
        allowedSortProperties.put("lastUpdateTime", (QueryProperty)ModelQueryProperty.MODEL_LAST_UPDATE_TIME);
        allowedSortProperties.put("name", (QueryProperty)ModelQueryProperty.MODEL_NAME);
        allowedSortProperties.put("version", (QueryProperty)ModelQueryProperty.MODEL_VERSION);
        allowedSortProperties.put("tenantId", (QueryProperty)ModelQueryProperty.MODEL_TENANT_ID);
    }
}

