/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.runtime.process;

import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.activiti.engine.runtime.Execution;
import org.activiti.rest.service.api.engine.variable.RestVariable;
import org.activiti.rest.service.api.runtime.process.BaseVariableCollectionResource;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ProcessInstanceVariableCollectionResource
extends BaseVariableCollectionResource {
    @RequestMapping(value={"/runtime/process-instances/{processInstanceId}/variables"}, method={RequestMethod.GET}, produces={"application/json"})
    public List<RestVariable> getVariables(@PathVariable String processInstanceId, @RequestParam(value="scope", required=false) String scope, HttpServletRequest request) {
        Execution execution = this.getProcessInstanceFromRequest(processInstanceId);
        return this.processVariables(execution, scope, 3);
    }

    @RequestMapping(value={"/runtime/process-instances/{processInstanceId}/variables"}, method={RequestMethod.PUT}, produces={"application/json"})
    public Object createOrUpdateExecutionVariable(@PathVariable String processInstanceId, HttpServletRequest request, HttpServletResponse response) {
        Execution execution = this.getProcessInstanceFromRequest(processInstanceId);
        return this.createExecutionVariable(execution, true, 3, request, response);
    }

    @RequestMapping(value={"/runtime/process-instances/{processInstanceId}/variables"}, method={RequestMethod.POST}, produces={"application/json"})
    public Object createExecutionVariable(@PathVariable String processInstanceId, HttpServletRequest request, HttpServletResponse response) {
        Execution execution = this.getProcessInstanceFromRequest(processInstanceId);
        return this.createExecutionVariable(execution, false, 3, request, response);
    }

    @RequestMapping(value={"/runtime/process-instances/{processInstanceId}/variables"}, method={RequestMethod.DELETE})
    public void deleteLocalVariables(@PathVariable String processInstanceId, HttpServletResponse response) {
        Execution execution = this.getProcessInstanceFromRequest(processInstanceId);
        this.deleteAllLocalVariables(execution, response);
    }

    @Override
    protected void addGlobalVariables(Execution execution, int variableType, Map<String, RestVariable> variableMap) {
    }

    @Override
    protected void addLocalVariables(Execution execution, int variableType, Map<String, RestVariable> variableMap) {
        Map rawVariables = this.runtimeService.getVariables(execution.getId());
        List<RestVariable> globalVariables = this.restResponseFactory.createRestVariables(rawVariables, execution.getId(), variableType, RestVariable.RestVariableScope.LOCAL);
        for (RestVariable var : globalVariables) {
            if (variableMap.containsKey(var.getName())) continue;
            variableMap.put(var.getName(), var);
        }
    }
}

