/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.repository;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import javax.servlet.http.HttpServletResponse;
import org.activiti.engine.ActivitiObjectNotFoundException;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.rest.service.api.repository.BaseDeploymentResourceDataResource;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"Process Definitions"}, description="Manage Process Definitions", authorizations={@Authorization(value="basicAuth")})
public class ProcessDefinitionResourceDataResource
extends BaseDeploymentResourceDataResource {
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates both process definition and resource have been found and the resource data has been returned."), @ApiResponse(code=404, message="Indicates the requested process definition was not found or there is no resource with the given id present in the process definition. The status-description contains additional information.")})
    @ApiOperation(value="Get a process definition resource content", tags={"Process Definitions"})
    @RequestMapping(value={"/repository/process-definitions/{processDefinitionId}/resourcedata"}, method={RequestMethod.GET})
    @ResponseBody
    public byte[] getProcessDefinitionResource(@ApiParam(name="processDefinitionId", value="The id of the process definition to get the resource data for.") @PathVariable String processDefinitionId, HttpServletResponse response) {
        ProcessDefinition processDefinition = this.getProcessDefinitionFromRequest(processDefinitionId);
        return this.getDeploymentResourceData(processDefinition.getDeploymentId(), processDefinition.getResourceName(), response);
    }

    protected ProcessDefinition getProcessDefinitionFromRequest(String processDefinitionId) {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionId(processDefinitionId).singleResult();
        if (processDefinition == null) {
            throw new ActivitiObjectNotFoundException("Could not find a process definition with id '" + processDefinitionId + "'.", ProcessDefinition.class);
        }
        return processDefinition;
    }
}

