/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.runtime.task;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.activiti.engine.ActivitiObjectNotFoundException;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.task.Event;
import org.activiti.engine.task.Task;
import org.activiti.rest.service.api.engine.EventResponse;
import org.activiti.rest.service.api.runtime.task.TaskBaseResource;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"Tasks"}, description="Manage Tasks", authorizations={@Authorization(value="basicAuth")})
public class TaskEventResource
extends TaskBaseResource {
    @ApiOperation(value="Get an event on a task", tags={"Tasks"})
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates the task and event were found and the event is returned."), @ApiResponse(code=404, message="Indicates the requested task was not found or the tasks doesn\u2019t have an event with the given ID.")})
    @RequestMapping(value={"/runtime/tasks/{taskId}/events/{eventId}"}, method={RequestMethod.GET}, produces={"application/json"})
    public EventResponse getEvent(@ApiParam(name="taskId", value="The id of the task to get the event for.") @PathVariable(value="taskId") String taskId, @ApiParam(name="eventId", value="The id of the event.") @PathVariable(value="eventId") String eventId, HttpServletRequest request) {
        HistoricTaskInstance task = this.getHistoricTaskFromRequest(taskId);
        Event event = this.taskService.getEvent(eventId);
        if (event == null || !task.getId().equals(event.getTaskId())) {
            throw new ActivitiObjectNotFoundException("Task '" + task.getId() + "' doesn't have an event with id '" + eventId + "'.", Event.class);
        }
        return this.restResponseFactory.createEventResponse(event);
    }

    @ApiOperation(value="Delete an event on a task", tags={"Tasks"})
    @ApiResponses(value={@ApiResponse(code=204, message="Indicates the task was found and the events are returned."), @ApiResponse(code=404, message="Indicates the requested task was not found or the task doesn\u2019t have the requested event.")})
    @RequestMapping(value={"/runtime/tasks/{taskId}/events/{eventId}"}, method={RequestMethod.DELETE})
    public void deleteEvent(@ApiParam(name="taskId") @PathVariable(value="taskId") String taskId, @ApiParam(name="eventId") @PathVariable(value="eventId") String eventId, HttpServletResponse response) {
        Task task = this.getTaskFromRequest(taskId);
        Event event = this.taskService.getEvent(eventId);
        if (event == null || event.getTaskId() == null || !event.getTaskId().equals(task.getId())) {
            throw new ActivitiObjectNotFoundException("Task '" + task.getId() + "' doesn't have an event with id '" + event + "'.", Event.class);
        }
        this.taskService.deleteComment(eventId);
        response.setStatus(HttpStatus.NO_CONTENT.value());
    }
}

