/*
 * Decompiled with CFR 0.152.
 */
package alluxio;

import alluxio.AbstractClient;
import alluxio.Configuration;
import alluxio.PropertyKey;
import alluxio.util.network.NetworkAddressUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.net.InetSocketAddress;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;
import javax.security.auth.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public abstract class AbstractMasterClient
extends AbstractClient {
    private static final Logger LOG = LoggerFactory.getLogger((String)"alluxio.logger.type");
    protected final String mZkLeaderPath;

    public AbstractMasterClient(Subject subject, InetSocketAddress masterAddress) {
        super(subject, masterAddress, "master");
        this.mZkLeaderPath = Configuration.getBoolean(PropertyKey.ZOOKEEPER_ENABLED) ? Configuration.get(PropertyKey.ZOOKEEPER_LEADER_PATH) : null;
    }

    public AbstractMasterClient(Subject subject, String zkLeaderPath) {
        super(subject, NetworkAddressUtils.getLeaderAddressFromZK(zkLeaderPath), "master");
        Preconditions.checkState((boolean)Configuration.getBoolean(PropertyKey.ZOOKEEPER_ENABLED));
        this.mZkLeaderPath = zkLeaderPath;
    }

    @Override
    public synchronized InetSocketAddress getAddress() {
        if (this.mZkLeaderPath == null) {
            return super.getAddress();
        }
        return NetworkAddressUtils.getLeaderAddressFromZK(this.mZkLeaderPath);
    }

    public synchronized List<InetSocketAddress> getMasterAddresses() {
        if (this.mZkLeaderPath == null) {
            return Lists.newArrayList((Object[])new InetSocketAddress[]{super.getAddress()});
        }
        return NetworkAddressUtils.getMasterAddressesFromZK();
    }
}

