/*
 * Decompiled with CFR 0.152.
 */
package alluxio;

import alluxio.exception.AlluxioException;
import alluxio.network.connection.ThriftClientPool;
import alluxio.retry.CountingRetry;
import alluxio.thrift.AlluxioService;
import alluxio.thrift.AlluxioTException;
import alluxio.thrift.ThriftIOException;
import com.google.common.base.Preconditions;
import java.io.IOException;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractThriftClient<C extends AlluxioService.Client> {
    private static final Logger LOG = LoggerFactory.getLogger((String)"alluxio.logger.type");
    private static final int RPC_MAX_NUM_RETRY = 30;

    protected abstract C acquireClient() throws IOException;

    protected abstract void releaseClient(C var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <V> V retryRPC(RpcCallable<V, C> rpc) throws IOException {
        TException exception = null;
        CountingRetry retryPolicy = new CountingRetry(30);
        do {
            C client = this.acquireClient();
            try {
                V v = rpc.call(client);
                return v;
            }
            catch (ThriftIOException e) {
                throw new IOException((Throwable)((Object)e));
            }
            catch (AlluxioTException e) {
                AlluxioException ae = AlluxioException.fromThrift(e);
                try {
                    this.processException(client, ae);
                }
                catch (AlluxioException ee) {
                    throw new IOException(ee);
                }
                exception = new TException((Throwable)ae);
            }
            catch (TException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                this.closeClient(client);
                exception = e;
            }
            finally {
                this.releaseClient(client);
            }
        } while (retryPolicy.attemptRetry());
        LOG.error("Failed after " + retryPolicy.getRetryCount() + " retries.");
        Preconditions.checkNotNull((Object)((Object)exception));
        throw new IOException(exception);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <V> V retryRPC(RpcCallableThrowsAlluxioTException<V, C> rpc) throws AlluxioException, IOException {
        TException exception = null;
        CountingRetry retryPolicy = new CountingRetry(30);
        do {
            C client = this.acquireClient();
            try {
                V v = rpc.call(client);
                return v;
            }
            catch (AlluxioTException e) {
                AlluxioException ae = AlluxioException.fromThrift(e);
                this.processException(client, ae);
                exception = new TException((Throwable)ae);
            }
            catch (ThriftIOException e) {
                throw new IOException((Throwable)((Object)e));
            }
            catch (TException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                this.closeClient(client);
                exception = e;
            }
            finally {
                this.releaseClient(client);
            }
        } while (retryPolicy.attemptRetry());
        LOG.error("Failed after " + retryPolicy.getRetryCount() + " retries.");
        Preconditions.checkNotNull((Object)((Object)exception));
        throw new IOException(exception);
    }

    protected <E extends Exception> void processException(C client, E e) throws E {
        throw e;
    }

    private void closeClient(C client) {
        ThriftClientPool.closeThriftClient(client);
    }

    protected static interface RpcCallableThrowsAlluxioTException<V, C extends AlluxioService.Client> {
        public V call(C var1) throws AlluxioTException, TException;
    }

    protected static interface RpcCallable<V, C extends AlluxioService.Client> {
        public V call(C var1) throws TException;
    }
}

