/*
 * Decompiled with CFR 0.152.
 */
package alluxio;

import alluxio.URI;
import alluxio.util.URIUtils;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.lang.StringUtils;

@ThreadSafe
public final class AlluxioURI
implements Comparable<AlluxioURI>,
Serializable {
    private static final long serialVersionUID = -1207227692436086387L;
    public static final String SEPARATOR = "/";
    public static final String CUR_DIR = ".";
    public static final String WILDCARD = "*";
    public static final AlluxioURI EMPTY_URI = new AlluxioURI("");
    private final URI mUri;

    public AlluxioURI(String pathStr) {
        this.mUri = URI.Factory.create(pathStr);
    }

    public AlluxioURI(String scheme, String authority, String path) {
        this.mUri = URI.Factory.create(scheme, authority, path, null);
    }

    public AlluxioURI(String scheme, String authority, String path, Map<String, String> queryMap) {
        this.mUri = URI.Factory.create(scheme, authority, path, URIUtils.generateQueryString(queryMap));
    }

    public AlluxioURI(AlluxioURI parent, AlluxioURI child) {
        this.mUri = URI.Factory.create(parent.mUri, child.mUri);
    }

    private AlluxioURI(String scheme, String authority, String path, String query) {
        this.mUri = URI.Factory.create(scheme, authority, path, query);
    }

    @Override
    public int compareTo(AlluxioURI other) {
        return this.mUri.compareTo(other.mUri);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AlluxioURI)) {
            return false;
        }
        AlluxioURI that = (AlluxioURI)o;
        return this.mUri.equals(that.mUri);
    }

    public String getAuthority() {
        return this.mUri.getAuthority();
    }

    public int getDepth() {
        int slash;
        String path = this.mUri.getPath();
        if (path.isEmpty()) {
            return 0;
        }
        if (AlluxioURI.hasWindowsDrive(path, true)) {
            path = path.substring(3);
        }
        int depth = 0;
        int n = slash = path.length() == 1 && path.charAt(0) == '/' ? -1 : 0;
        while (slash != -1) {
            ++depth;
            slash = path.indexOf(SEPARATOR, slash + 1);
        }
        return depth;
    }

    public String getLeadingPath(int n) {
        String path = this.mUri.getPath();
        if (n == 0 && path.indexOf(SEPARATOR) == 0) {
            return SEPARATOR;
        }
        int depth = this.getDepth();
        if (depth < n) {
            return null;
        }
        if (depth == n) {
            return path;
        }
        String[] comp = path.split(SEPARATOR);
        return StringUtils.join(Arrays.asList(comp).subList(0, n + 1), (String)SEPARATOR);
    }

    public boolean containsWildcard() {
        return this.mUri.getPath().contains(WILDCARD);
    }

    public String getHost() {
        return this.mUri.getHost();
    }

    public String getName() {
        String path = this.mUri.getPath();
        int slash = path.lastIndexOf(SEPARATOR);
        return path.substring(slash + 1);
    }

    public AlluxioURI getParent() {
        String parent;
        int start;
        String path = this.mUri.getPath();
        int lastSlash = path.lastIndexOf(47);
        int n = start = AlluxioURI.hasWindowsDrive(path, true) ? 3 : 0;
        if (path.length() == start || lastSlash == start && path.length() == start + 1) {
            return null;
        }
        if (lastSlash == -1) {
            parent = CUR_DIR;
        } else {
            int end = AlluxioURI.hasWindowsDrive(path, true) ? 3 : 0;
            parent = path.substring(0, lastSlash == end ? end + 1 : lastSlash);
        }
        return new AlluxioURI(this.mUri.getScheme(), this.mUri.getAuthority(), parent, this.mUri.getQuery());
    }

    public String getPath() {
        return this.mUri.getPath();
    }

    public int getPort() {
        return this.mUri.getPort();
    }

    public Map<String, String> getQueryMap() {
        return URIUtils.parseQueryString(this.mUri.getQuery());
    }

    public String getScheme() {
        return this.mUri.getScheme();
    }

    public boolean hasAuthority() {
        return this.mUri.getAuthority() != null;
    }

    public int hashCode() {
        return this.mUri.hashCode();
    }

    public boolean hasScheme() {
        return this.mUri.getScheme() != null;
    }

    public static boolean hasWindowsDrive(String path, boolean slashed) {
        int start = slashed ? 1 : 0;
        return path.length() >= start + 2 && (!slashed || path.charAt(0) == '/') && path.charAt(start + 1) == ':' && (path.charAt(start) >= 'A' && path.charAt(start) <= 'Z' || path.charAt(start) >= 'a' && path.charAt(start) <= 'z');
    }

    public boolean isAbsolute() {
        return this.mUri.isAbsolute();
    }

    public boolean isPathAbsolute() {
        int start = AlluxioURI.hasWindowsDrive(this.mUri.getPath(), true) ? 3 : 0;
        return this.mUri.getPath().startsWith(SEPARATOR, start);
    }

    public boolean isRoot() {
        return this.mUri.getPath().equals(SEPARATOR) || this.mUri.getPath().isEmpty() && this.mUri.getAuthority() != null;
    }

    public AlluxioURI join(String suffix) {
        return new AlluxioURI(this.getScheme(), this.getAuthority(), this.getPath() + SEPARATOR + suffix, this.mUri.getQuery());
    }

    public AlluxioURI join(AlluxioURI suffix) {
        return this.join(suffix.toString());
    }

    public static String normalizePath(String path) {
        int minLength;
        while (path.contains("\\")) {
            path = path.replace("\\", SEPARATOR);
        }
        while (path.contains("//")) {
            path = path.replace("//", SEPARATOR);
        }
        int n = minLength = AlluxioURI.hasWindowsDrive(path, true) ? 4 : 1;
        while (path.length() > minLength && path.endsWith(SEPARATOR)) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.mUri.getScheme() != null) {
            sb.append(this.mUri.getScheme());
            sb.append("://");
        }
        if (this.mUri.getAuthority() != null) {
            if (this.mUri.getScheme() == null) {
                sb.append("//");
            }
            sb.append(this.mUri.getAuthority());
        }
        if (this.mUri.getPath() != null) {
            String path = this.mUri.getPath();
            if (path.indexOf(47) == 0 && AlluxioURI.hasWindowsDrive(path, true) && this.mUri.getScheme() == null && this.mUri.getAuthority() == null) {
                path = path.substring(1);
            }
            sb.append(path);
        }
        if (this.mUri.getQuery() != null) {
            sb.append("?");
            sb.append(this.mUri.getQuery());
        }
        return sb.toString();
    }
}

