/*
 * Decompiled with CFR 0.152.
 */
package alluxio;

import alluxio.PropertyKey;
import alluxio.exception.ExceptionMessage;
import alluxio.exception.PreconditionMessage;
import alluxio.network.ChannelType;
import alluxio.util.ConfigurationUtils;
import alluxio.util.FormatUtils;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import io.netty.util.internal.chmv8.ConcurrentHashMapV8;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public final class Configuration {
    private static final Logger LOG = LoggerFactory.getLogger((String)"alluxio.logger.type");
    private static final String REGEX_STRING = "(\\$\\{([^{}]*)\\})";
    private static final Pattern CONF_REGEX = Pattern.compile("(\\$\\{([^{}]*)\\})");
    private static final ConcurrentHashMapV8<String, String> PROPERTIES = new ConcurrentHashMapV8();
    public static final String SITE_PROPERTIES = "alluxio-site.properties";

    public static void defaultInit() {
        String confPaths;
        String[] confPathList;
        Properties siteProps;
        Properties defaultProps = new Properties();
        for (PropertyKey key : PropertyKey.values()) {
            String value = key.getDefaultValue();
            if (value == null) continue;
            defaultProps.setProperty(key.toString(), value);
        }
        defaultProps.setProperty(PropertyKey.WORKER_NETWORK_NETTY_CHANNEL.toString(), String.valueOf((Object)ChannelType.defaultType()));
        defaultProps.setProperty(PropertyKey.USER_NETWORK_NETTY_CHANNEL.toString(), String.valueOf((Object)ChannelType.defaultType()));
        Properties systemProps = new Properties();
        systemProps.putAll((Map<?, ?>)System.getProperties());
        PROPERTIES.clear();
        Configuration.merge(defaultProps);
        Configuration.merge(systemProps);
        if (!Configuration.getBoolean(PropertyKey.TEST_MODE) && (siteProps = ConfigurationUtils.searchPropertiesFile(SITE_PROPERTIES, confPathList = (confPaths = Configuration.get(PropertyKey.SITE_CONF_DIR)).split(","))) != null) {
            Configuration.merge(siteProps);
            Configuration.merge(systemProps);
        }
        if (Configuration.containsKey(PropertyKey.MASTER_HOSTNAME)) {
            String masterHostname = Configuration.get(PropertyKey.MASTER_HOSTNAME);
            String masterPort = Configuration.get(PropertyKey.MASTER_RPC_PORT);
            boolean useZk = Boolean.parseBoolean(Configuration.get(PropertyKey.ZOOKEEPER_ENABLED));
            String masterAddress = (useZk ? "alluxio-ft://" : "alluxio://") + masterHostname + ":" + masterPort;
            Configuration.set(PropertyKey.MASTER_ADDRESS, masterAddress);
        }
        Preconditions.checkState((boolean)Configuration.validate());
        Configuration.checkConfigurationValues();
    }

    public static void merge(Map<?, ?> properties) {
        if (properties != null) {
            for (Map.Entry<?, ?> entry : properties.entrySet()) {
                String key = entry.getKey().toString();
                String value = entry.getValue().toString();
                if (!PropertyKey.isValid(key)) continue;
                PROPERTIES.put((Object)key, (Object)value);
            }
        }
        Configuration.checkUserFileBufferBytes();
    }

    public static void set(PropertyKey key, Object value) {
        Preconditions.checkArgument((key != null && value != null ? 1 : 0) != 0, (Object)String.format("the key value pair (%s, %s) cannot have null", new Object[]{key, value}));
        PROPERTIES.put((Object)key.toString(), (Object)value.toString());
        Configuration.checkUserFileBufferBytes();
    }

    public static void unset(PropertyKey key) {
        Preconditions.checkNotNull((Object)((Object)key));
        PROPERTIES.remove((Object)key.toString());
    }

    public static String get(PropertyKey key) {
        String rawValue = (String)PROPERTIES.get((Object)key.toString());
        if (rawValue == null) {
            throw new RuntimeException(ExceptionMessage.UNDEFINED_CONFIGURATION_KEY.getMessage(new Object[]{key}));
        }
        return Configuration.lookup(rawValue);
    }

    public static boolean containsKey(PropertyKey key) {
        return PROPERTIES.containsKey((Object)key.toString());
    }

    public static int getInt(PropertyKey key) {
        String rawValue = Configuration.get(key);
        try {
            return Integer.parseInt(Configuration.lookup(rawValue));
        }
        catch (NumberFormatException e) {
            throw new RuntimeException(ExceptionMessage.KEY_NOT_INTEGER.getMessage(new Object[]{key}));
        }
    }

    public static long getLong(PropertyKey key) {
        String rawValue = Configuration.get(key);
        try {
            return Long.parseLong(Configuration.lookup(rawValue));
        }
        catch (NumberFormatException e) {
            throw new RuntimeException(ExceptionMessage.KEY_NOT_LONG.getMessage(new Object[]{key}));
        }
    }

    public static double getDouble(PropertyKey key) {
        String rawValue = Configuration.get(key);
        try {
            return Double.parseDouble(Configuration.lookup(rawValue));
        }
        catch (NumberFormatException e) {
            throw new RuntimeException(ExceptionMessage.KEY_NOT_DOUBLE.getMessage(new Object[]{key}));
        }
    }

    public static float getFloat(PropertyKey key) {
        String rawValue = Configuration.get(key);
        try {
            return Float.parseFloat(Configuration.lookup(rawValue));
        }
        catch (NumberFormatException e) {
            throw new RuntimeException(ExceptionMessage.KEY_NOT_FLOAT.getMessage(new Object[]{key}));
        }
    }

    public static boolean getBoolean(PropertyKey key) {
        String rawValue = Configuration.get(key);
        if (rawValue.equalsIgnoreCase("true")) {
            return true;
        }
        if (rawValue.equalsIgnoreCase("false")) {
            return false;
        }
        throw new RuntimeException(ExceptionMessage.KEY_NOT_BOOLEAN.getMessage(new Object[]{key}));
    }

    public static List<String> getList(PropertyKey key, String delimiter) {
        Preconditions.checkArgument((delimiter != null ? 1 : 0) != 0, (Object)"Illegal separator for Alluxio properties as list");
        String rawValue = Configuration.get(key);
        return Lists.newLinkedList((Iterable)Splitter.on((String)delimiter).trimResults().omitEmptyStrings().split((CharSequence)rawValue));
    }

    public static <T extends Enum<T>> T getEnum(PropertyKey key, Class<T> enumType) {
        String rawValue = Configuration.get(key);
        return Enum.valueOf(enumType, rawValue);
    }

    public static long getBytes(PropertyKey key) {
        String rawValue = Configuration.get(key);
        try {
            return FormatUtils.parseSpaceSize(rawValue);
        }
        catch (Exception ex) {
            throw new RuntimeException(ExceptionMessage.KEY_NOT_BYTES.getMessage(new Object[]{key}));
        }
    }

    public static <T> Class<T> getClass(PropertyKey key) {
        String rawValue = Configuration.get(key);
        try {
            Class<?> clazz = Class.forName(rawValue);
            return clazz;
        }
        catch (Exception e) {
            LOG.error("requested class could not be loaded: {}", (Object)rawValue, (Object)e);
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static Map<String, String> toMap() {
        return Collections.unmodifiableMap(PROPERTIES);
    }

    private static String lookup(String base) {
        return Configuration.lookupRecursively(base, new HashMap<String, String>());
    }

    private static String lookupRecursively(String base, Map<String, String> found) {
        if (base == null) {
            return null;
        }
        String resolved = base;
        Matcher matcher = CONF_REGEX.matcher(base);
        while (matcher.find()) {
            String value;
            String match = matcher.group(2).trim();
            if (!found.containsKey(match)) {
                value = Configuration.lookupRecursively((String)PROPERTIES.get((Object)match), found);
                found.put(match, value);
            } else {
                value = found.get(match);
            }
            if (value == null) continue;
            LOG.debug("Replacing {} with {}", (Object)matcher.group(1), (Object)value);
            resolved = resolved.replaceFirst(REGEX_STRING, Matcher.quoteReplacement(value));
        }
        return resolved;
    }

    private static void checkWorkerPorts() {
        int maxWorkersPerHost = Configuration.getInt(PropertyKey.INTEGRATION_YARN_WORKERS_PER_HOST_MAX);
        if (maxWorkersPerHost > 1) {
            String message = "%s cannot be specified when allowing multiple workers per host with " + PropertyKey.INTEGRATION_YARN_WORKERS_PER_HOST_MAX.toString() + "=" + maxWorkersPerHost;
            Preconditions.checkState((System.getProperty(PropertyKey.WORKER_DATA_PORT.toString()) == null ? 1 : 0) != 0, (Object)String.format(message, new Object[]{PropertyKey.WORKER_DATA_PORT}));
            Preconditions.checkState((System.getProperty(PropertyKey.WORKER_RPC_PORT.toString()) == null ? 1 : 0) != 0, (Object)String.format(message, new Object[]{PropertyKey.WORKER_RPC_PORT}));
            Preconditions.checkState((System.getProperty(PropertyKey.WORKER_WEB_PORT.toString()) == null ? 1 : 0) != 0, (Object)String.format(message, new Object[]{PropertyKey.WORKER_WEB_PORT}));
            Configuration.set(PropertyKey.WORKER_DATA_PORT, "0");
            Configuration.set(PropertyKey.WORKER_RPC_PORT, "0");
            Configuration.set(PropertyKey.WORKER_WEB_PORT, "0");
        }
    }

    private static void checkUserFileBufferBytes() {
        if (!Configuration.containsKey(PropertyKey.USER_FILE_BUFFER_BYTES)) {
            return;
        }
        long usrFileBufferBytes = Configuration.getBytes(PropertyKey.USER_FILE_BUFFER_BYTES);
        Preconditions.checkArgument(((usrFileBufferBytes & Integer.MAX_VALUE) == usrFileBufferBytes ? 1 : 0) != 0, (String)PreconditionMessage.INVALID_USER_FILE_BUFFER_BYTES.toString(), (Object[])new Object[]{usrFileBufferBytes});
    }

    private static void checkZkConfiguration() {
        if (Configuration.getBoolean(PropertyKey.ZOOKEEPER_ENABLED)) {
            Preconditions.checkState((boolean)Configuration.containsKey(PropertyKey.ZOOKEEPER_ADDRESS), (String)PreconditionMessage.ERR_ZK_ADDRESS_NOT_SET.toString(), (Object[])new Object[]{PropertyKey.ZOOKEEPER_ADDRESS.toString()});
        }
        if (Configuration.containsKey(PropertyKey.ZOOKEEPER_ADDRESS)) {
            LOG.warn("{} is configured, but {} is set to false", (Object)PropertyKey.ZOOKEEPER_ADDRESS.toString(), (Object)PropertyKey.ZOOKEEPER_ENABLED.toString());
        }
    }

    private static void checkConfigurationValues() {
        Configuration.checkWorkerPorts();
        Configuration.checkUserFileBufferBytes();
        Configuration.checkZkConfiguration();
    }

    public static boolean validate() {
        boolean valid = true;
        for (Map.Entry<String, String> entry : Configuration.toMap().entrySet()) {
            String propertyName = entry.getKey();
            if (PropertyKey.isValid(propertyName)) continue;
            LOG.error("Unsupported property " + propertyName);
            valid = false;
        }
        return valid;
    }

    private Configuration() {
    }

    static {
        Configuration.defaultInit();
    }
}

