/*
 * Decompiled with CFR 0.152.
 */
package alluxio;

import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.recipes.leader.LeaderSelector;
import org.apache.curator.framework.recipes.leader.LeaderSelectorListener;
import org.apache.curator.framework.recipes.leader.Participant;
import org.apache.curator.framework.state.ConnectionState;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public final class LeaderSelectorClient
implements Closeable,
LeaderSelectorListener {
    private static final Logger LOG = LoggerFactory.getLogger((String)"alluxio.logger.type");
    private final String mElectionPath;
    private final String mLeaderFolder;
    private final LeaderSelector mLeaderSelector;
    private final String mName;
    private final String mZookeeperAddress;
    private AtomicBoolean mIsLeader = new AtomicBoolean(false);
    private volatile Thread mCurrentMasterThread = null;

    public LeaderSelectorClient(String zookeeperAddress, String electionPath, String leaderPath, String name) {
        this.mZookeeperAddress = zookeeperAddress;
        this.mElectionPath = electionPath;
        this.mLeaderFolder = leaderPath.endsWith("/") ? leaderPath : leaderPath + "/";
        this.mName = name;
        this.mLeaderSelector = new LeaderSelector(this.getNewCuratorClient(), this.mElectionPath, (LeaderSelectorListener)this);
        this.mLeaderSelector.setId(name);
        this.mLeaderSelector.autoRequeue();
    }

    @Override
    public void close() throws IOException {
        block3: {
            if (this.mCurrentMasterThread != null) {
                this.mCurrentMasterThread.interrupt();
            }
            try {
                this.mLeaderSelector.close();
            }
            catch (IllegalStateException e) {
                if (e.getMessage().equals("Already closed or has not been started")) break block3;
                throw e;
            }
        }
    }

    public String getName() {
        return this.mName;
    }

    public List<String> getParticipants() {
        try {
            ArrayList participants = new ArrayList(this.mLeaderSelector.getParticipants());
            ArrayList<String> results = new ArrayList<String>();
            for (Participant part : participants) {
                results.add(part.getId());
            }
            return results;
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public boolean isLeader() {
        return this.mIsLeader.get();
    }

    public void setCurrentMasterThread(Thread currentMasterThread) {
        this.mCurrentMasterThread = (Thread)Preconditions.checkNotNull((Object)currentMasterThread);
    }

    public void start() throws IOException {
        this.mLeaderSelector.start();
    }

    public void stateChanged(CuratorFramework client, ConnectionState newState) {
        this.mIsLeader.set(false);
        if (newState == ConnectionState.LOST || newState == ConnectionState.SUSPENDED) {
            if (this.mCurrentMasterThread != null) {
                this.mCurrentMasterThread.interrupt();
            }
        } else {
            try {
                LOG.info("The current leader is {}", (Object)this.mLeaderSelector.getLeader().getId());
            }
            catch (Exception e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void takeLeadership(CuratorFramework client) throws Exception {
        this.mIsLeader.set(true);
        if (client.checkExists().forPath(this.mLeaderFolder + this.mName) != null) {
            LOG.info("Deleting zk path: {}{}", (Object)this.mLeaderFolder, (Object)this.mName);
            client.delete().forPath(this.mLeaderFolder + this.mName);
        }
        LOG.info("Creating zk path: {}{}", (Object)this.mLeaderFolder, (Object)this.mName);
        client.create().creatingParentsIfNeeded().forPath(this.mLeaderFolder + this.mName);
        LOG.info("{} is now the leader.", (Object)this.mName);
        try {
            try {
                while (true) {
                    Thread.sleep(TimeUnit.SECONDS.toMillis(5L));
                }
            }
            catch (InterruptedException e) {
                LOG.error(this.mName + " was interrupted.", (Throwable)e);
                Thread.currentThread().interrupt();
                this.mIsLeader.set(false);
                this.mCurrentMasterThread = null;
                LOG.warn("{} relinquishing leadership.", (Object)this.mName);
                LOG.info("The current leader is {}", (Object)this.mLeaderSelector.getLeader().getId());
                LOG.info("All participants: {}", (Object)this.mLeaderSelector.getParticipants());
                client.delete().forPath(this.mLeaderFolder + this.mName);
            }
        }
        catch (Throwable throwable) {
            this.mIsLeader.set(false);
            this.mCurrentMasterThread = null;
            LOG.warn("{} relinquishing leadership.", (Object)this.mName);
            LOG.info("The current leader is {}", (Object)this.mLeaderSelector.getLeader().getId());
            LOG.info("All participants: {}", (Object)this.mLeaderSelector.getParticipants());
            client.delete().forPath(this.mLeaderFolder + this.mName);
            throw throwable;
        }
    }

    private CuratorFramework getNewCuratorClient() {
        CuratorFramework client = CuratorFrameworkFactory.newClient((String)this.mZookeeperAddress, (RetryPolicy)new ExponentialBackoffRetry(1000, 3));
        client.start();
        client.close();
        client = CuratorFrameworkFactory.newClient((String)this.mZookeeperAddress, (RetryPolicy)new ExponentialBackoffRetry(1000, 3));
        client.start();
        return client;
    }
}

