/*
 * Decompiled with CFR 0.152.
 */
package alluxio;

import alluxio.Configuration;
import alluxio.PropertyKey;
import alluxio.util.CommonUtils;
import alluxio.util.io.PathUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.curator.CuratorZookeeperClient;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class MasterInquireClient {
    private static final Logger LOG = LoggerFactory.getLogger((String)"alluxio.logger.type");
    private static HashMap<String, MasterInquireClient> sCreatedClients = new HashMap();
    private final String mZookeeperAddress;
    private final String mElectionPath;
    private final String mLeaderPath;
    private final CuratorFramework mClient;
    private final int mMaxTry;

    public static synchronized MasterInquireClient getClient(String zookeeperAddress, String electionPath, String leaderPath) {
        String key = zookeeperAddress + leaderPath;
        if (!sCreatedClients.containsKey(key)) {
            sCreatedClients.put(key, new MasterInquireClient(zookeeperAddress, electionPath, leaderPath));
        }
        return sCreatedClients.get(key);
    }

    private MasterInquireClient(String zookeeperAddress, String electionPath, String leaderPath) {
        this.mZookeeperAddress = zookeeperAddress;
        this.mElectionPath = electionPath;
        this.mLeaderPath = leaderPath;
        LOG.info("Creating new zookeeper client. address: {}", (Object)this.mZookeeperAddress);
        this.mClient = CuratorFrameworkFactory.newClient((String)this.mZookeeperAddress, (RetryPolicy)new ExponentialBackoffRetry(1000, 3));
        this.mClient.start();
        this.mMaxTry = Configuration.getInt(PropertyKey.ZOOKEEPER_LEADER_INQUIRY_RETRY_COUNT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String getLeaderAddress() {
        long startTime = System.currentTimeMillis();
        int tried = 0;
        try {
            CuratorZookeeperClient curatorClient = this.mClient.getZookeeperClient();
            for (int i = 0; i < 50 && !curatorClient.isConnected(); ++i) {
                CommonUtils.sleepMs(20L);
            }
            curatorClient.blockUntilConnectedOrTimedOut();
            while (tried < this.mMaxTry) {
                ZooKeeper zookeeper = curatorClient.getZooKeeper();
                if (zookeeper.exists(this.mLeaderPath, false) != null) {
                    List masters = zookeeper.getChildren(this.mLeaderPath, null);
                    LOG.info("Master addresses: {}", (Object)masters);
                    if (masters.size() >= 1) {
                        if (masters.size() == 1) {
                            String string = (String)masters.get(0);
                            return string;
                        }
                        long maxTime = 0L;
                        String leader = "";
                        for (String master : masters) {
                            Stat stat = zookeeper.exists(PathUtils.concatPath(this.mLeaderPath, master), null);
                            if (stat == null || stat.getCtime() <= maxTime) continue;
                            maxTime = stat.getCtime();
                            leader = master;
                        }
                        LOG.info("The leader master: {}", (Object)leader);
                        String string = leader;
                        return string;
                    }
                } else {
                    LOG.info("{} does not exist ({})", (Object)this.mLeaderPath, (Object)(++tried));
                }
                CommonUtils.sleepMs(LOG, 1000L);
            }
        }
        catch (Exception e) {
            LOG.error("Error getting the leader master address from zookeeper. Zookeeper address: {}", (Object)this.mZookeeperAddress, (Object)e);
        }
        finally {
            LOG.debug("Finished getLeaderAddress() in {}ms", (Object)(System.currentTimeMillis() - startTime));
        }
        return null;
    }

    public synchronized List<String> getMasterAddresses() {
        int tried = 0;
        try {
            while (tried < this.mMaxTry) {
                if (this.mClient.checkExists().forPath(this.mElectionPath) != null) {
                    List children = (List)this.mClient.getChildren().forPath(this.mElectionPath);
                    ArrayList<String> ret = new ArrayList<String>();
                    for (String child : children) {
                        byte[] data = (byte[])this.mClient.getData().forPath(PathUtils.concatPath(this.mElectionPath, child));
                        if (data == null) continue;
                        ret.add(new String(data, "utf-8"));
                    }
                    LOG.info("All masters: {}", ret);
                    return ret;
                }
                LOG.info("{} does not exist ({})", (Object)this.mElectionPath, (Object)(++tried));
            }
        }
        catch (Exception e) {
            LOG.error("Error getting the master addresses from zookeeper. Zookeeper address: {}", (Object)this.mZookeeperAddress, (Object)e);
        }
        return null;
    }
}

