/*
 * Decompiled with CFR 0.152.
 */
package alluxio;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public enum PropertyKey {
    CONF_DIR("alluxio.conf.dir", String.format("${%s}/conf", "alluxio.home")),
    DEBUG("alluxio.debug", false),
    HOME("alluxio.home", "/opt/alluxio"),
    KEY_VALUE_ENABLED("alluxio.keyvalue.enabled", false),
    KEY_VALUE_PARTITION_SIZE_BYTES_MAX("alluxio.keyvalue.partition.size.bytes.max", "512MB"),
    LOGGER_TYPE("alluxio.logger.type", "Console"),
    LOGS_DIR("alluxio.logs.dir", String.format("${%s}/logs", "alluxio.work.dir")),
    METRICS_CONF_FILE("alluxio.metrics.conf.file", String.format("${%s}/metrics.properties", "alluxio.conf.dir")),
    NETWORK_HOST_RESOLUTION_TIMEOUT_MS("alluxio.network.host.resolution.timeout.ms", 5000),
    NETWORK_THRIFT_FRAME_SIZE_BYTES_MAX("alluxio.network.thrift.frame.size.bytes.max", "16MB"),
    SITE_CONF_DIR("alluxio.site.conf.dir", "${user.home}/.alluxio/,/etc/alluxio/"),
    TEST_MODE("alluxio.test.mode", false),
    VERSION("alluxio.version", "1.4.0"),
    WEB_RESOURCES("alluxio.web.resources", String.format("${%s}/core/server/src/main/webapp", "alluxio.home")),
    WEB_THREADS("alluxio.web.threads", 1),
    WORK_DIR("alluxio.work.dir", String.format("${%s}", "alluxio.home")),
    ZOOKEEPER_ADDRESS("alluxio.zookeeper.address", null),
    ZOOKEEPER_ELECTION_PATH("alluxio.zookeeper.election.path", "/election"),
    ZOOKEEPER_ENABLED("alluxio.zookeeper.enabled", false),
    ZOOKEEPER_LEADER_INQUIRY_RETRY_COUNT("alluxio.zookeeper.leader.inquiry.retry", 10),
    ZOOKEEPER_LEADER_PATH("alluxio.zookeeper.leader.path", "/leader"),
    UNDERFS_ADDRESS("alluxio.underfs.address", String.format("${%s}/underFSStorage", "alluxio.work.dir")),
    UNDERFS_ALLOW_SET_OWNER_FAILURE("alluxio.underfs.allow.set.owner.failure", false),
    UNDERFS_LISTING_LENGTH("alluxio.underfs.listing.length", 1000),
    UNDERFS_GCS_OWNER_ID_TO_USERNAME_MAPPING("alluxio.underfs.gcs.owner.id.to.username.mapping", ""),
    UNDERFS_GLUSTERFS_IMPL("alluxio.underfs.glusterfs.impl", "org.apache.hadoop.fs.glusterfs.GlusterFileSystem"),
    UNDERFS_GLUSTERFS_MOUNTS("alluxio.underfs.glusterfs.mounts", null),
    UNDERFS_GLUSTERFS_MR_DIR("alluxio.underfs.glusterfs.mapred.system.dir", "glusterfs:///mapred/system"),
    UNDERFS_GLUSTERFS_VOLUMES("alluxio.underfs.glusterfs.volumes", null),
    UNDERFS_HDFS_CONFIGURATION("alluxio.underfs.hdfs.configuration", String.format("${%s}/core-site.xml", "alluxio.conf.dir")),
    UNDERFS_HDFS_IMPL("alluxio.underfs.hdfs.impl", "org.apache.hadoop.hdfs.DistributedFileSystem"),
    UNDERFS_HDFS_PREFIXES("alluxio.underfs.hdfs.prefixes", "hdfs://,glusterfs:///,maprfs:///"),
    UNDERFS_HDFS_REMOTE("alluxio.underfs.hdfs.remote", false),
    UNDERFS_OBJECT_STORE_MOUNT_SHARED_PUBLICLY("alluxio.underfs.object.store.mount.shared.publicly", false),
    UNDERFS_OSS_CONNECT_MAX("alluxio.underfs.oss.connection.max", 1024),
    UNDERFS_OSS_CONNECT_TIMEOUT("alluxio.underfs.oss.connection.timeout.ms", 50000),
    UNDERFS_OSS_CONNECT_TTL("alluxio.underfs.oss.connection.ttl", -1),
    UNDERFS_OSS_SOCKET_TIMEOUT("alluxio.underfs.oss.socket.timeout.ms", 50000),
    UNDERFS_S3_ADMIN_THREADS_MAX("alluxio.underfs.s3.admin.threads.max", 20),
    UNDERFS_S3_DISABLE_DNS_BUCKETS("alluxio.underfs.s3.disable.dns.buckets", false),
    UNDERFS_S3_ENDPOINT("alluxio.underfs.s3.endpoint", null),
    UNDERFS_S3_ENDPOINT_HTTP_PORT("alluxio.underfs.s3.endpoint.http.port", null),
    UNDERFS_S3_ENDPOINT_HTTPS_PORT("alluxio.underfs.s3.endpoint.https.port", null),
    UNDERFS_S3_OWNER_ID_TO_USERNAME_MAPPING("alluxio.underfs.s3.owner.id.to.username.mapping", ""),
    UNDERFS_S3_PROXY_HOST("alluxio.underfs.s3.proxy.host", null),
    UNDERFS_S3_PROXY_HTTPS_ONLY("alluxio.underfs.s3.proxy.https.only", true),
    UNDERFS_S3_PROXY_PORT("alluxio.underfs.s3.proxy.port", null),
    UNDERFS_S3_THREADS_MAX("alluxio.underfs.s3.threads.max", 40),
    UNDERFS_S3_UPLOAD_THREADS_MAX("alluxio.underfs.s3.upload.threads.max", 20),
    UNDERFS_S3A_CONSISTENCY_TIMEOUT_MS("alluxio.underfs.s3a.consistency.timeout.ms", 60000),
    UNDERFS_S3A_INHERIT_ACL("alluxio.underfs.s3a.inherit_acl", true),
    UNDERFS_S3A_REQUEST_TIMEOUT("alluxio.underfs.s3a.request.timeout.ms", 60000),
    UNDERFS_S3A_SECURE_HTTP_ENABLED("alluxio.underfs.s3a.secure.http.enabled", false),
    UNDERFS_S3A_SERVER_SIDE_ENCRYPTION_ENABLED("alluxio.underfs.s3a.server.side.encryption.enabled", false),
    UNDERFS_S3A_SOCKET_TIMEOUT_MS("alluxio.underfs.s3a.socket.timeout.ms", 50000),
    GCS_ACCESS_KEY("fs.gcs.accessKeyId", null),
    GCS_SECRET_KEY("fs.gcs.secretAccessKey", null),
    OSS_ACCESS_KEY("fs.oss.accessKeyId", null),
    OSS_ENDPOINT_KEY("fs.oss.endpoint", null),
    OSS_SECRET_KEY("fs.oss.accessKeySecret", null),
    S3A_ACCESS_KEY("aws.accessKeyId", null),
    S3A_SECRET_KEY("aws.secretKey", null),
    S3N_ACCESS_KEY("fs.s3n.awsAccessKeyId", null),
    S3N_SECRET_KEY("fs.s3n.awsSecretAccessKey", null),
    SWIFT_API_KEY("fs.swift.apikey", null),
    SWIFT_AUTH_METHOD_KEY("fs.swift.auth.method", null),
    SWIFT_AUTH_URL_KEY("fs.swift.auth.url", null),
    SWIFT_PASSWORD_KEY("fs.swift.password", null),
    SWIFT_SIMULATION("fs.swift.simulation", null),
    SWIFT_TENANT_KEY("fs.swift.tenant", null),
    SWIFT_USE_PUBLIC_URI_KEY("fs.swift.use.public.url", null),
    SWIFT_USER_KEY("fs.swift.user", null),
    SWIFT_REGION_KEY("fs.swift.region", null),
    MASTER_ADDRESS("alluxio.master.address", null),
    MASTER_BIND_HOST("alluxio.master.bind.host", "0.0.0.0"),
    MASTER_FILE_ASYNC_PERSIST_HANDLER("alluxio.master.file.async.persist.handler", "alluxio.master.file.async.DefaultAsyncPersistHandler"),
    MASTER_FORMAT_FILE_PREFIX("alluxio.master.format.file_prefix", "_format_"),
    MASTER_HEARTBEAT_INTERVAL_MS("alluxio.master.heartbeat.interval.ms", 1000),
    MASTER_HOSTNAME("alluxio.master.hostname", null),
    MASTER_JOURNAL_FLUSH_BATCH_TIME_MS("alluxio.master.journal.flush.batch.time.ms", 5),
    MASTER_JOURNAL_FOLDER("alluxio.master.journal.folder", String.format("${%s}/journal", "alluxio.work.dir")),
    MASTER_JOURNAL_FORMATTER_CLASS("alluxio.master.journal.formatter.class", "alluxio.master.journal.ProtoBufJournalFormatter"),
    MASTER_JOURNAL_LOG_SIZE_BYTES_MAX("alluxio.master.journal.log.size.bytes.max", "10MB"),
    MASTER_JOURNAL_TAILER_SHUTDOWN_QUIET_WAIT_TIME_MS("alluxio.master.journal.tailer.shutdown.quiet.wait.time.ms", 5000),
    MASTER_JOURNAL_TAILER_SLEEP_TIME_MS("alluxio.master.journal.tailer.sleep.time.ms", 1000),
    MASTER_KEYTAB_KEY_FILE("alluxio.master.keytab.file", null),
    MASTER_LINEAGE_CHECKPOINT_CLASS("alluxio.master.lineage.checkpoint.class", "alluxio.master.lineage.checkpoint.CheckpointLatestPlanner"),
    MASTER_LINEAGE_CHECKPOINT_INTERVAL_MS("alluxio.master.lineage.checkpoint.interval.ms", 300000),
    MASTER_LINEAGE_RECOMPUTE_INTERVAL_MS("alluxio.master.lineage.recompute.interval.ms", 300000),
    MASTER_LINEAGE_RECOMPUTE_LOG_PATH("alluxio.master.lineage.recompute.log.path", String.format("${%s}/recompute.log", "alluxio.logs.dir")),
    MASTER_PRINCIPAL("alluxio.master.principal", null),
    MASTER_RETRY("alluxio.master.retry", 29),
    MASTER_RPC_PORT("alluxio.master.port", 19998),
    MASTER_STARTUP_CONSISTENCY_CHECK_ENABLED("alluxio.master.startup.consistency.check.enabled", true),
    MASTER_TIERED_STORE_GLOBAL_LEVEL0_ALIAS("alluxio.master.tieredstore.global.level0.alias", "MEM"),
    MASTER_TIERED_STORE_GLOBAL_LEVEL1_ALIAS("alluxio.master.tieredstore.global.level1.alias", "SSD"),
    MASTER_TIERED_STORE_GLOBAL_LEVEL2_ALIAS("alluxio.master.tieredstore.global.level2.alias", "HDD"),
    MASTER_TIERED_STORE_GLOBAL_LEVELS("alluxio.master.tieredstore.global.levels", 3),
    MASTER_TTL_CHECKER_INTERVAL_MS("alluxio.master.ttl.checker.interval.ms", 3600000),
    MASTER_WEB_BIND_HOST("alluxio.master.web.bind.host", "0.0.0.0"),
    MASTER_WEB_HOSTNAME("alluxio.master.web.hostname", null),
    MASTER_WEB_PORT("alluxio.master.web.port", 19999),
    MASTER_WHITELIST("alluxio.master.whitelist", "/"),
    MASTER_WORKER_THREADS_MAX("alluxio.master.worker.threads.max", 2048),
    MASTER_WORKER_THREADS_MIN("alluxio.master.worker.threads.min", 512),
    MASTER_WORKER_TIMEOUT_MS("alluxio.master.worker.timeout.ms", 300000),
    WORKER_ALLOCATOR_CLASS("alluxio.worker.allocator.class", "alluxio.worker.block.allocator.MaxFreeAllocator"),
    WORKER_BIND_HOST("alluxio.worker.bind.host", "0.0.0.0"),
    WORKER_BLOCK_HEARTBEAT_INTERVAL_MS("alluxio.worker.block.heartbeat.interval.ms", 1000),
    WORKER_BLOCK_HEARTBEAT_TIMEOUT_MS("alluxio.worker.block.heartbeat.timeout.ms", 60000),
    WORKER_BLOCK_THREADS_MAX("alluxio.worker.block.threads.max", 2048),
    WORKER_BLOCK_THREADS_MIN("alluxio.worker.block.threads.min", 256),
    WORKER_DATA_BIND_HOST("alluxio.worker.data.bind.host", "0.0.0.0"),
    WORKER_DATA_FOLDER("alluxio.worker.data.folder", "/alluxioworker/"),
    WORKER_DATA_HOSTNAME("alluxio.worker.data.hostname", null),
    WORKER_DATA_PORT("alluxio.worker.data.port", 29999),
    WORKER_DATA_SERVER_CLASS("alluxio.worker.data.server.class", "alluxio.worker.netty.NettyDataServer"),
    WORKER_DATA_TMP_FOLDER("alluxio.worker.data.folder.tmp", ".tmp_blocks"),
    WORKER_DATA_TMP_SUBDIR_MAX("alluxio.worker.data.tmp.subdir.max", 1024),
    WORKER_EVICTOR_CLASS("alluxio.worker.evictor.class", "alluxio.worker.block.evictor.LRUEvictor"),
    WORKER_EVICTOR_LRFU_ATTENUATION_FACTOR("alluxio.worker.evictor.lrfu.attenuation.factor", 2.0),
    WORKER_EVICTOR_LRFU_STEP_FACTOR("alluxio.worker.evictor.lrfu.step.factor", 0.25),
    WORKER_FILE_PERSIST_POOL_SIZE("alluxio.worker.file.persist.pool.size", 64),
    WORKER_FILE_PERSIST_RATE_LIMIT("alluxio.worker.file.persist.rate.limit", "2GB"),
    WORKER_FILE_PERSIST_RATE_LIMIT_ENABLED("alluxio.worker.file.persist.rate.limit.enabled", false),
    WORKER_FILE_BUFFER_SIZE("alluxio.worker.file.buffer.size", "1MB"),
    WORKER_FILESYSTEM_HEARTBEAT_INTERVAL_MS("alluxio.worker.filesystem.heartbeat.interval.ms", 1000),
    WORKER_HOSTNAME("alluxio.worker.hostname", null),
    WORKER_KEYTAB_FILE("alluxio.worker.keytab.file", null),
    WORKER_MEMORY_SIZE("alluxio.worker.memory.size", "1GB"),
    WORKER_NETWORK_NETTY_BACKLOG("alluxio.worker.network.netty.backlog", null),
    WORKER_NETWORK_NETTY_BOSS_THREADS("alluxio.worker.network.netty.boss.threads", 1),
    WORKER_NETWORK_NETTY_BUFFER_RECEIVE("alluxio.worker.network.netty.buffer.receive", null),
    WORKER_NETWORK_NETTY_BUFFER_SEND("alluxio.worker.network.netty.buffer.send", null),
    WORKER_NETWORK_NETTY_CHANNEL("alluxio.worker.network.netty.channel", null),
    WORKER_NETWORK_NETTY_FILE_TRANSFER_TYPE("alluxio.worker.network.netty.file.transfer", "MAPPED"),
    WORKER_NETWORK_NETTY_SHUTDOWN_QUIET_PERIOD("alluxio.worker.network.netty.shutdown.quiet.period", 2),
    WORKER_NETWORK_NETTY_SHUTDOWN_TIMEOUT("alluxio.worker.network.netty.shutdown.timeout", 15),
    WORKER_NETWORK_NETTY_WATERMARK_HIGH("alluxio.worker.network.netty.watermark.high", "32KB"),
    WORKER_NETWORK_NETTY_WATERMARK_LOW("alluxio.worker.network.netty.watermark.low", "8KB"),
    WORKER_NETWORK_NETTY_WORKER_THREADS("alluxio.worker.network.netty.worker.threads", 0),
    WORKER_NETWORK_NETTY_WRITER_BUFFER_SIZE_PACKETS("alluxio.worker.network.netty.writer.buffer.size.packets", 16),
    WORKER_NETWORK_NETTY_READER_BUFFER_SIZE_PACKETS("alluxio.worker.network.netty.reader.buffer.size.packets", 16),
    WORKER_NETWORK_NETTY_READER_PACKET_SIZE_BYTES("alluxio.worker.network.netty.reader.packet.size.bytes", "64KB"),
    WORKER_NETWORK_NETTY_BLOCK_READER_THREADS_MAX("alluxio.worker.network.netty.block.reader.threads.max", 128),
    WORKER_NETWORK_NETTY_BLOCK_WRITER_THREADS_MAX("alluxio.worker.network.netty.block.writer.threads.max", 128),
    WORKER_NETWORK_NETTY_FILE_READER_THREADS_MAX("alluxio.worker.network.netty.file.reader.threads.max", 128),
    WORKER_NETWORK_NETTY_FILE_WRITER_THREADS_MAX("alluxio.worker.network.netty.file.writer.threads.max", 128),
    WORKER_PRINCIPAL("alluxio.worker.principal", null),
    WORKER_RPC_PORT("alluxio.worker.port", 29998),
    WORKER_SESSION_TIMEOUT_MS("alluxio.worker.session.timeout.ms", 60000),
    WORKER_TIERED_STORE_BLOCK_LOCK_READERS("alluxio.worker.tieredstore.block.lock.readers", 1000),
    WORKER_TIERED_STORE_BLOCK_LOCKS("alluxio.worker.tieredstore.block.locks", 1000),
    WORKER_TIERED_STORE_LEVEL0_ALIAS("alluxio.worker.tieredstore.level0.alias", "MEM"),
    WORKER_TIERED_STORE_LEVEL0_DIRS_PATH("alluxio.worker.tieredstore.level0.dirs.path", "/mnt/ramdisk"),
    WORKER_TIERED_STORE_LEVEL0_DIRS_QUOTA("alluxio.worker.tieredstore.level0.dirs.quota", "${alluxio.worker.memory.size}"),
    WORKER_TIERED_STORE_LEVEL0_RESERVED_RATIO("alluxio.worker.tieredstore.level0.reserved.ratio", "0.1"),
    WORKER_TIERED_STORE_LEVEL1_ALIAS("alluxio.worker.tieredstore.level1.alias", null),
    WORKER_TIERED_STORE_LEVEL1_DIRS_PATH("alluxio.worker.tieredstore.level1.dirs.path", null),
    WORKER_TIERED_STORE_LEVEL1_DIRS_QUOTA("alluxio.worker.tieredstore.level1.dirs.quota", null),
    WORKER_TIERED_STORE_LEVEL1_RESERVED_RATIO("alluxio.worker.tieredstore.level1.reserved.ratio", null),
    WORKER_TIERED_STORE_LEVEL2_ALIAS("alluxio.worker.tieredstore.level2.alias", null),
    WORKER_TIERED_STORE_LEVEL2_DIRS_PATH("alluxio.worker.tieredstore.level2.dirs.path", null),
    WORKER_TIERED_STORE_LEVEL2_DIRS_QUOTA("alluxio.worker.tieredstore.level2.dirs.quota", null),
    WORKER_TIERED_STORE_LEVEL2_RESERVED_RATIO("alluxio.worker.tieredstore.level2.reserved.ratio", null),
    WORKER_TIERED_STORE_LEVELS("alluxio.worker.tieredstore.levels", 1),
    WORKER_TIERED_STORE_RESERVER_ENABLED("alluxio.worker.tieredstore.reserver.enabled", false),
    WORKER_TIERED_STORE_RESERVER_INTERVAL_MS("alluxio.worker.tieredstore.reserver.interval.ms", 1000),
    WORKER_TIERED_STORE_RETRY("alluxio.worker.tieredstore.retry", 3),
    WORKER_WEB_BIND_HOST("alluxio.worker.web.bind.host", "0.0.0.0"),
    WORKER_WEB_HOSTNAME("alluxio.worker.web.hostname", null),
    WORKER_WEB_PORT("alluxio.worker.web.port", 30000),
    PROXY_STREAM_CACHE_TIMEOUT_MS("alluxio.proxy.stream.cache.timeout.ms", 3600000),
    PROXY_WEB_BIND_HOST("alluxio.proxy.web.bind.host", "0.0.0.0"),
    PROXY_WEB_HOSTNAME("alluxio.proxy.web.hostname", null),
    PROXY_WEB_PORT("alluxio.proxy.web.port", 39999),
    USER_BLOCK_MASTER_CLIENT_THREADS("alluxio.user.block.master.client.threads", 10),
    USER_BLOCK_REMOTE_READ_BUFFER_SIZE_BYTES("alluxio.user.block.remote.read.buffer.size.bytes", "8MB"),
    USER_BLOCK_REMOTE_READER_CLASS("alluxio.user.block.remote.reader.class", "alluxio.client.netty.NettyRemoteBlockReader"),
    USER_BLOCK_REMOTE_WRITER_CLASS("alluxio.user.block.remote.writer.class", "alluxio.client.netty.NettyRemoteBlockWriter"),
    USER_BLOCK_SIZE_BYTES_DEFAULT("alluxio.user.block.size.bytes.default", "512MB"),
    USER_BLOCK_WORKER_CLIENT_THREADS("alluxio.user.block.worker.client.threads", 10),
    USER_BLOCK_WORKER_CLIENT_POOL_SIZE_MAX("alluxio.user.block.worker.client.pool.size.max", 128),
    USER_BLOCK_WORKER_CLIENT_POOL_GC_THRESHOLD_MS("alluxio.user.block.worker.client.pool.gc.threshold.ms", 300000),
    USER_FAILED_SPACE_REQUEST_LIMITS("alluxio.user.failed.space.request.limits", 3),
    USER_FILE_BUFFER_BYTES("alluxio.user.file.buffer.bytes", "1MB"),
    USER_FILE_CACHE_PARTIALLY_READ_BLOCK("alluxio.user.file.cache.partially.read.block", true),
    USER_FILE_MASTER_CLIENT_THREADS("alluxio.user.file.master.client.threads", 10),
    USER_FILE_READ_TYPE_DEFAULT("alluxio.user.file.readtype.default", "CACHE_PROMOTE"),
    USER_FILE_SEEK_BUFFER_SIZE_BYTES("alluxio.user.file.seek.buffer.size.bytes", "1MB"),
    USER_FILE_WAITCOMPLETED_POLL_MS("alluxio.user.file.waitcompleted.poll.ms", 1000),
    USER_FILE_WORKER_CLIENT_THREADS("alluxio.user.file.worker.client.threads", 10),
    USER_FILE_WORKER_CLIENT_POOL_SIZE_MAX("alluxio.user.file.worker.client.pool.size.max", 128),
    USER_FILE_WORKER_CLIENT_POOL_GC_THRESHOLD_MS("alluxio.user.file.worker.client.pool.gc.threshold.ms", 300000),
    USER_FILE_WRITE_LOCATION_POLICY("alluxio.user.file.write.location.policy.class", "alluxio.client.file.policy.LocalFirstPolicy"),
    USER_FILE_WRITE_TYPE_DEFAULT("alluxio.user.file.writetype.default", "MUST_CACHE"),
    USER_FILE_WRITE_TIER_DEFAULT("alluxio.user.file.write.tier.default", 0),
    USER_HEARTBEAT_INTERVAL_MS("alluxio.user.heartbeat.interval.ms", 1000),
    USER_LINEAGE_ENABLED("alluxio.user.lineage.enabled", false),
    USER_LINEAGE_MASTER_CLIENT_THREADS("alluxio.user.lineage.master.client.threads", 10),
    USER_NETWORK_NETTY_CHANNEL("alluxio.user.network.netty.channel", null),
    USER_NETWORK_NETTY_TIMEOUT_MS("alluxio.user.network.netty.timeout.ms", 30000),
    USER_NETWORK_NETTY_WORKER_THREADS("alluxio.user.network.netty.worker.threads", 0),
    USER_NETWORK_NETTY_CHANNEL_POOL_SIZE_MAX("alluxio.user.network.netty.channel.pool.size.max", 1024),
    USER_NETWORK_NETTY_CHANNEL_POOL_GC_THRESHOLD_MS("alluxio.user.network.netty.channel.pool.gc.threshold.ms", 300000),
    USER_NETWORK_NETTY_CHANNEL_POOL_DISABLED("alluxio.user.network.netty.channel.pool.disabled", false),
    USER_NETWORK_NETTY_WRITER_PACKET_SIZE_BYTES("alluxio.user.network.netty.writer.packet.size.bytes", "64KB"),
    USER_NETWORK_NETTY_WRITER_BUFFER_SIZE_PACKETS("alluxio.user.network.netty.writer.buffer.size.packets", 16),
    USER_NETWORK_NETTY_READER_BUFFER_SIZE_PACKETS("alluxio.user.network.netty.reader.buffer.size.packets", 16),
    USER_NETWORK_NETTY_READER_CANCEL_ENABLED("alluxio.user.network.netty.reader.cancel.enabled", true),
    USER_UFS_DELEGATION_ENABLED("alluxio.user.ufs.delegation.enabled", true),
    USER_UFS_DELEGATION_READ_BUFFER_SIZE_BYTES("alluxio.user.ufs.delegation.read.buffer.size.bytes", "8MB"),
    USER_UFS_DELEGATION_WRITE_BUFFER_SIZE_BYTES("alluxio.user.ufs.delegation.write.buffer.size.bytes", "2MB"),
    USER_UFS_FILE_READER_CLASS("alluxio.user.ufs.file.reader.class", "alluxio.client.netty.NettyUnderFileSystemFileReader"),
    USER_UFS_FILE_WRITER_CLASS("alluxio.user.ufs.file.writer.class", "alluxio.client.netty.NettyUnderFileSystemFileWriter"),
    USER_LOCAL_READER_PACKET_SIZE_BYTES("alluxio.user.local.reader.packet.size.bytes", "8MB"),
    USER_LOCAL_WRITER_PACKET_SIZE_BYTES("alluxio.user.local.writer.packet.size.bytes", "64KB"),
    USER_PACKET_STREAMING_ENABLED("alluxio.user.packet.streaming.enabled", false),
    FUSE_CACHED_PATHS_MAX("alluxio.fuse.cached.paths.max", 500),
    FUSE_DEBUG_ENABLED("alluxio.fuse.debug.enabled", false),
    FUSE_FS_NAME("alluxio.fuse.fs.name", "alluxio-fuse"),
    FUSE_FS_ROOT("alluxio.fuse.fs.root", "/"),
    FUSE_MAXWRITE_BYTES("alluxio.fuse.maxwrite.bytes", 131072),
    FUSE_MOUNT_DEFAULT("alluxio.fuse.mount.default", "/mnt/alluxio"),
    SECURITY_AUTHENTICATION_CUSTOM_PROVIDER_CLASS("alluxio.security.authentication.custom.provider.class", null),
    SECURITY_AUTHENTICATION_SOCKET_TIMEOUT_MS("alluxio.security.authentication.socket.timeout.ms", "600000"),
    SECURITY_AUTHENTICATION_TYPE("alluxio.security.authentication.type", "SIMPLE"),
    SECURITY_AUTHORIZATION_PERMISSION_ENABLED("alluxio.security.authorization.permission.enabled", true),
    SECURITY_AUTHORIZATION_PERMISSION_SUPERGROUP("alluxio.security.authorization.permission.supergroup", "supergroup"),
    SECURITY_AUTHORIZATION_PERMISSION_UMASK("alluxio.security.authorization.permission.umask", "022"),
    SECURITY_GROUP_MAPPING_CACHE_TIMEOUT_MS("alluxio.security.group.mapping.cache.timeout.ms", "60000"),
    SECURITY_GROUP_MAPPING_CLASS("alluxio.security.group.mapping.class", "alluxio.security.group.provider.ShellBasedUnixGroupsMapping"),
    SECURITY_LOGIN_USERNAME("alluxio.security.login.username", null),
    INTEGRATION_MASTER_RESOURCE_CPU("alluxio.integration.master.resource.cpu", 1),
    INTEGRATION_MASTER_RESOURCE_MEM("alluxio.integration.master.resource.mem", "1024MB"),
    INTEGRATION_MESOS_ALLUXIO_JAR_URL("alluxio.integration.mesos.alluxio.jar.url", String.format("http://downloads.alluxio.org/downloads/files/${%s}/alluxio-${%s}-bin.tar.gz", "alluxio.version", "alluxio.version")),
    INTEGRATION_MESOS_ALLUXIO_MASTER_NAME("alluxio.integration.mesos.master.name", "AlluxioMaster"),
    INTEGRATION_MESOS_ALLUXIO_MASTER_NODE_COUNT("alluxio.integration.mesos.master.node.count", 1),
    INTEGRATION_MESOS_ALLUXIO_WORKER_NAME("alluxio.integration.mesos.worker.name", "AlluxioWorker"),
    INTEGRATION_MESOS_JDK_PATH("alluxio.integration.mesos.jdk.path", "jdk1.7.0_79"),
    INTEGRATION_MESOS_JDK_URL("alluxio.integration.mesos.jdk.url", "https://alluxio-mesos.s3.amazonaws.com/jdk-7u79-linux-x64.tar.gz"),
    INTEGRATION_MESOS_PRINCIPAL("alluxio.integration.mesos.principal", "alluxio"),
    INTEGRATION_MESOS_ROLE("alluxio.integration.mesos.role", "*"),
    INTEGRATION_MESOS_SECRET("alluxio.integration.mesos.secret", null),
    INTEGRATION_MESOS_USER("alluxio.integration.mesos.user", ""),
    INTEGRATION_WORKER_RESOURCE_CPU("alluxio.integration.worker.resource.cpu", 1),
    INTEGRATION_WORKER_RESOURCE_MEM("alluxio.integration.worker.resource.mem", "1024MB"),
    INTEGRATION_YARN_WORKERS_PER_HOST_MAX("alluxio.integration.yarn.workers.per.host.max", 1);

    private static final Map<String, PropertyKey> KEYS_MAP;
    private final String mName;
    private final String mDefaultValue;

    public static boolean isValid(String keyStr) {
        return KEYS_MAP.containsKey(keyStr);
    }

    public static PropertyKey fromString(String keyStr) {
        PropertyKey key = KEYS_MAP.get(keyStr);
        if (key == null) {
            throw new IllegalArgumentException("Invalid property key " + keyStr);
        }
        return key;
    }

    private static Map<String, PropertyKey> initKeysMap() {
        HashMap<String, PropertyKey> map = new HashMap<String, PropertyKey>();
        for (PropertyKey key : PropertyKey.values()) {
            map.put(key.toString(), key);
        }
        return map;
    }

    private PropertyKey(String property, Object defaultValue) {
        this.mName = property;
        this.mDefaultValue = defaultValue == null ? null : defaultValue.toString();
    }

    public String toString() {
        return this.mName;
    }

    public String getDefaultValue() {
        return this.mDefaultValue;
    }

    static {
        KEYS_MAP = PropertyKey.initKeysMap();
    }

    @ThreadSafe
    public static final class Name {
        public static final String CONF_DIR = "alluxio.conf.dir";
        public static final String DEBUG = "alluxio.debug";
        public static final String HOME = "alluxio.home";
        public static final String INTEGRATION_MASTER_RESOURCE_CPU = "alluxio.integration.master.resource.cpu";
        public static final String INTEGRATION_MASTER_RESOURCE_MEM = "alluxio.integration.master.resource.mem";
        public static final String INTEGRATION_MESOS_ALLUXIO_MASTER_NAME = "alluxio.integration.mesos.master.name";
        public static final String INTEGRATION_MESOS_ALLUXIO_MASTER_NODE_COUNT = "alluxio.integration.mesos.master.node.count";
        public static final String INTEGRATION_MESOS_ALLUXIO_WORKER_NAME = "alluxio.integration.mesos.worker.name";
        public static final String INTEGRATION_MESOS_ALLUXIO_JAR_URL = "alluxio.integration.mesos.alluxio.jar.url";
        public static final String INTEGRATION_MESOS_JDK_PATH = "alluxio.integration.mesos.jdk.path";
        public static final String INTEGRATION_MESOS_JDK_URL = "alluxio.integration.mesos.jdk.url";
        public static final String INTEGRATION_MESOS_PRINCIPAL = "alluxio.integration.mesos.principal";
        public static final String INTEGRATION_MESOS_ROLE = "alluxio.integration.mesos.role";
        public static final String INTEGRATION_MESOS_SECRET = "alluxio.integration.mesos.secret";
        public static final String INTEGRATION_MESOS_USER = "alluxio.integration.mesos.user";
        public static final String INTEGRATION_WORKER_RESOURCE_CPU = "alluxio.integration.worker.resource.cpu";
        public static final String INTEGRATION_WORKER_RESOURCE_MEM = "alluxio.integration.worker.resource.mem";
        public static final String INTEGRATION_YARN_WORKERS_PER_HOST_MAX = "alluxio.integration.yarn.workers.per.host.max";
        public static final String KEY_VALUE_ENABLED = "alluxio.keyvalue.enabled";
        public static final String KEY_VALUE_PARTITION_SIZE_BYTES_MAX = "alluxio.keyvalue.partition.size.bytes.max";
        public static final String LOGGER_TYPE = "alluxio.logger.type";
        public static final String LOGS_DIR = "alluxio.logs.dir";
        public static final String METRICS_CONF_FILE = "alluxio.metrics.conf.file";
        public static final String NETWORK_HOST_RESOLUTION_TIMEOUT_MS = "alluxio.network.host.resolution.timeout.ms";
        public static final String NETWORK_THRIFT_FRAME_SIZE_BYTES_MAX = "alluxio.network.thrift.frame.size.bytes.max";
        public static final String SITE_CONF_DIR = "alluxio.site.conf.dir";
        public static final String TEST_MODE = "alluxio.test.mode";
        public static final String VERSION = "alluxio.version";
        public static final String WEB_RESOURCES = "alluxio.web.resources";
        public static final String WEB_THREADS = "alluxio.web.threads";
        public static final String WORK_DIR = "alluxio.work.dir";
        public static final String ZOOKEEPER_ADDRESS = "alluxio.zookeeper.address";
        public static final String ZOOKEEPER_ELECTION_PATH = "alluxio.zookeeper.election.path";
        public static final String ZOOKEEPER_ENABLED = "alluxio.zookeeper.enabled";
        public static final String ZOOKEEPER_LEADER_INQUIRY_RETRY_COUNT = "alluxio.zookeeper.leader.inquiry.retry";
        public static final String ZOOKEEPER_LEADER_PATH = "alluxio.zookeeper.leader.path";
        public static final String UNDERFS_ADDRESS = "alluxio.underfs.address";
        public static final String UNDERFS_ALLOW_SET_OWNER_FAILURE = "alluxio.underfs.allow.set.owner.failure";
        public static final String UNDERFS_LISTING_LENGTH = "alluxio.underfs.listing.length";
        public static final String UNDERFS_GCS_OWNER_ID_TO_USERNAME_MAPPING = "alluxio.underfs.gcs.owner.id.to.username.mapping";
        public static final String UNDERFS_GLUSTERFS_IMPL = "alluxio.underfs.glusterfs.impl";
        public static final String UNDERFS_GLUSTERFS_MOUNTS = "alluxio.underfs.glusterfs.mounts";
        public static final String UNDERFS_GLUSTERFS_MR_DIR = "alluxio.underfs.glusterfs.mapred.system.dir";
        public static final String UNDERFS_GLUSTERFS_VOLUMES = "alluxio.underfs.glusterfs.volumes";
        public static final String UNDERFS_HDFS_CONFIGURATION = "alluxio.underfs.hdfs.configuration";
        public static final String UNDERFS_HDFS_IMPL = "alluxio.underfs.hdfs.impl";
        public static final String UNDERFS_HDFS_PREFIXES = "alluxio.underfs.hdfs.prefixes";
        public static final String UNDERFS_HDFS_REMOTE = "alluxio.underfs.hdfs.remote";
        public static final String UNDERFS_OBJECT_STORE_MOUNT_SHARED_PUBLICLY = "alluxio.underfs.object.store.mount.shared.publicly";
        public static final String UNDERFS_OSS_CONNECT_MAX = "alluxio.underfs.oss.connection.max";
        public static final String UNDERFS_OSS_CONNECT_TIMEOUT = "alluxio.underfs.oss.connection.timeout.ms";
        public static final String UNDERFS_OSS_CONNECT_TTL = "alluxio.underfs.oss.connection.ttl";
        public static final String UNDERFS_OSS_SOCKET_TIMEOUT = "alluxio.underfs.oss.socket.timeout.ms";
        public static final String UNDERFS_S3A_INHERIT_ACL = "alluxio.underfs.s3a.inherit_acl";
        public static final String UNDERFS_S3A_CONSISTENCY_TIMEOUT_MS = "alluxio.underfs.s3a.consistency.timeout.ms";
        public static final String UNDERFS_S3A_REQUEST_TIMEOUT_MS = "alluxio.underfs.s3a.request.timeout.ms";
        public static final String UNDERFS_S3A_SECURE_HTTP_ENABLED = "alluxio.underfs.s3a.secure.http.enabled";
        public static final String UNDERFS_S3A_SERVER_SIDE_ENCRYPTION_ENABLED = "alluxio.underfs.s3a.server.side.encryption.enabled";
        public static final String UNDERFS_S3A_SOCKET_TIMEOUT_MS = "alluxio.underfs.s3a.socket.timeout.ms";
        public static final String UNDERFS_S3_ADMIN_THREADS_MAX = "alluxio.underfs.s3.admin.threads.max";
        public static final String UNDERFS_S3_DISABLE_DNS_BUCKETS = "alluxio.underfs.s3.disable.dns.buckets";
        public static final String UNDERFS_S3_ENDPOINT = "alluxio.underfs.s3.endpoint";
        public static final String UNDERFS_S3_ENDPOINT_HTTPS_PORT = "alluxio.underfs.s3.endpoint.https.port";
        public static final String UNDERFS_S3_ENDPOINT_HTTP_PORT = "alluxio.underfs.s3.endpoint.http.port";
        public static final String UNDERFS_S3_OWNER_ID_TO_USERNAME_MAPPING = "alluxio.underfs.s3.owner.id.to.username.mapping";
        public static final String UNDERFS_S3_PROXY_HOST = "alluxio.underfs.s3.proxy.host";
        public static final String UNDERFS_S3_PROXY_HTTPS_ONLY = "alluxio.underfs.s3.proxy.https.only";
        public static final String UNDERFS_S3_PROXY_PORT = "alluxio.underfs.s3.proxy.port";
        public static final String UNDERFS_S3_THREADS_MAX = "alluxio.underfs.s3.threads.max";
        public static final String UNDERFS_S3_UPLOAD_THREADS_MAX = "alluxio.underfs.s3.upload.threads.max";
        public static final String GCS_ACCESS_KEY = "fs.gcs.accessKeyId";
        public static final String GCS_SECRET_KEY = "fs.gcs.secretAccessKey";
        public static final String OSS_ACCESS_KEY = "fs.oss.accessKeyId";
        public static final String OSS_ENDPOINT_KEY = "fs.oss.endpoint";
        public static final String OSS_SECRET_KEY = "fs.oss.accessKeySecret";
        public static final String S3A_ACCESS_KEY = "aws.accessKeyId";
        public static final String S3A_SECRET_KEY = "aws.secretKey";
        public static final String S3N_ACCESS_KEY = "fs.s3n.awsAccessKeyId";
        public static final String S3N_SECRET_KEY = "fs.s3n.awsSecretAccessKey";
        public static final String SWIFT_API_KEY = "fs.swift.apikey";
        public static final String SWIFT_AUTH_METHOD_KEY = "fs.swift.auth.method";
        public static final String SWIFT_AUTH_URL_KEY = "fs.swift.auth.url";
        public static final String SWIFT_PASSWORD_KEY = "fs.swift.password";
        public static final String SWIFT_SIMULATION = "fs.swift.simulation";
        public static final String SWIFT_TENANT_KEY = "fs.swift.tenant";
        public static final String SWIFT_USER_KEY = "fs.swift.user";
        public static final String SWIFT_USE_PUBLIC_URI_KEY = "fs.swift.use.public.url";
        public static final String SWIFT_REGION_KEY = "fs.swift.region";
        public static final String MASTER_ADDRESS = "alluxio.master.address";
        public static final String MASTER_BIND_HOST = "alluxio.master.bind.host";
        public static final String MASTER_FILE_ASYNC_PERSIST_HANDLER = "alluxio.master.file.async.persist.handler";
        public static final String MASTER_FORMAT_FILE_PREFIX = "alluxio.master.format.file_prefix";
        public static final String MASTER_HEARTBEAT_INTERVAL_MS = "alluxio.master.heartbeat.interval.ms";
        public static final String MASTER_HOSTNAME = "alluxio.master.hostname";
        public static final String MASTER_JOURNAL_FLUSH_BATCH_TIME_MS = "alluxio.master.journal.flush.batch.time.ms";
        public static final String MASTER_JOURNAL_FOLDER = "alluxio.master.journal.folder";
        public static final String MASTER_JOURNAL_FORMATTER_CLASS = "alluxio.master.journal.formatter.class";
        public static final String MASTER_JOURNAL_LOG_SIZE_BYTES_MAX = "alluxio.master.journal.log.size.bytes.max";
        public static final String MASTER_JOURNAL_TAILER_SHUTDOWN_QUIET_WAIT_TIME_MS = "alluxio.master.journal.tailer.shutdown.quiet.wait.time.ms";
        public static final String MASTER_JOURNAL_TAILER_SLEEP_TIME_MS = "alluxio.master.journal.tailer.sleep.time.ms";
        public static final String MASTER_KEYTAB_KEY_FILE = "alluxio.master.keytab.file";
        public static final String MASTER_LINEAGE_CHECKPOINT_CLASS = "alluxio.master.lineage.checkpoint.class";
        public static final String MASTER_LINEAGE_CHECKPOINT_INTERVAL_MS = "alluxio.master.lineage.checkpoint.interval.ms";
        public static final String MASTER_LINEAGE_RECOMPUTE_INTERVAL_MS = "alluxio.master.lineage.recompute.interval.ms";
        public static final String MASTER_LINEAGE_RECOMPUTE_LOG_PATH = "alluxio.master.lineage.recompute.log.path";
        public static final String MASTER_PRINCIPAL = "alluxio.master.principal";
        public static final String MASTER_RETRY = "alluxio.master.retry";
        public static final String MASTER_RPC_PORT = "alluxio.master.port";
        public static final String MASTER_STARTUP_CONSISTENCY_CHECK_ENABLED = "alluxio.master.startup.consistency.check.enabled";
        public static final String MASTER_TIERED_STORE_GLOBAL_LEVEL0_ALIAS = "alluxio.master.tieredstore.global.level0.alias";
        public static final String MASTER_TIERED_STORE_GLOBAL_LEVEL1_ALIAS = "alluxio.master.tieredstore.global.level1.alias";
        public static final String MASTER_TIERED_STORE_GLOBAL_LEVEL2_ALIAS = "alluxio.master.tieredstore.global.level2.alias";
        public static final String MASTER_TIERED_STORE_GLOBAL_LEVELS = "alluxio.master.tieredstore.global.levels";
        public static final String MASTER_TTL_CHECKER_INTERVAL_MS = "alluxio.master.ttl.checker.interval.ms";
        public static final String MASTER_WEB_BIND_HOST = "alluxio.master.web.bind.host";
        public static final String MASTER_WEB_HOSTNAME = "alluxio.master.web.hostname";
        public static final String MASTER_WEB_PORT = "alluxio.master.web.port";
        public static final String MASTER_WHITELIST = "alluxio.master.whitelist";
        public static final String MASTER_WORKER_THREADS_MAX = "alluxio.master.worker.threads.max";
        public static final String MASTER_WORKER_THREADS_MIN = "alluxio.master.worker.threads.min";
        public static final String MASTER_WORKER_TIMEOUT_MS = "alluxio.master.worker.timeout.ms";
        public static final String WORKER_ALLOCATOR_CLASS = "alluxio.worker.allocator.class";
        public static final String WORKER_BIND_HOST = "alluxio.worker.bind.host";
        public static final String WORKER_BLOCK_HEARTBEAT_INTERVAL_MS = "alluxio.worker.block.heartbeat.interval.ms";
        public static final String WORKER_BLOCK_HEARTBEAT_TIMEOUT_MS = "alluxio.worker.block.heartbeat.timeout.ms";
        public static final String WORKER_BLOCK_THREADS_MAX = "alluxio.worker.block.threads.max";
        public static final String WORKER_BLOCK_THREADS_MIN = "alluxio.worker.block.threads.min";
        public static final String WORKER_DATA_BIND_HOST = "alluxio.worker.data.bind.host";
        public static final String WORKER_DATA_FOLDER = "alluxio.worker.data.folder";
        public static final String WORKER_DATA_HOSTNAME = "alluxio.worker.data.hostname";
        public static final String WORKER_DATA_PORT = "alluxio.worker.data.port";
        public static final String WORKER_DATA_SERVER_CLASS = "alluxio.worker.data.server.class";
        public static final String WORKER_DATA_TMP_FOLDER = "alluxio.worker.data.folder.tmp";
        public static final String WORKER_DATA_TMP_SUBDIR_MAX = "alluxio.worker.data.tmp.subdir.max";
        public static final String WORKER_EVICTOR_CLASS = "alluxio.worker.evictor.class";
        public static final String WORKER_EVICTOR_LRFU_ATTENUATION_FACTOR = "alluxio.worker.evictor.lrfu.attenuation.factor";
        public static final String WORKER_EVICTOR_LRFU_STEP_FACTOR = "alluxio.worker.evictor.lrfu.step.factor";
        public static final String WORKER_FILESYSTEM_HEARTBEAT_INTERVAL_MS = "alluxio.worker.filesystem.heartbeat.interval.ms";
        public static final String WORKER_FILE_PERSIST_POOL_SIZE = "alluxio.worker.file.persist.pool.size";
        public static final String WORKER_FILE_PERSIST_RATE_LIMIT = "alluxio.worker.file.persist.rate.limit";
        public static final String WORKER_FILE_PERSIST_RATE_LIMIT_ENABLED = "alluxio.worker.file.persist.rate.limit.enabled";
        public static final String WORKER_FILE_BUFFER_SIZE = "alluxio.worker.file.buffer.size";
        public static final String WORKER_HOSTNAME = "alluxio.worker.hostname";
        public static final String WORKER_KEYTAB_FILE = "alluxio.worker.keytab.file";
        public static final String WORKER_MEMORY_SIZE = "alluxio.worker.memory.size";
        public static final String WORKER_NETWORK_NETTY_BACKLOG = "alluxio.worker.network.netty.backlog";
        public static final String WORKER_NETWORK_NETTY_BOSS_THREADS = "alluxio.worker.network.netty.boss.threads";
        public static final String WORKER_NETWORK_NETTY_BUFFER_RECEIVE = "alluxio.worker.network.netty.buffer.receive";
        public static final String WORKER_NETWORK_NETTY_BUFFER_SEND = "alluxio.worker.network.netty.buffer.send";
        public static final String WORKER_NETWORK_NETTY_CHANNEL = "alluxio.worker.network.netty.channel";
        public static final String WORKER_NETWORK_NETTY_FILE_TRANSFER_TYPE = "alluxio.worker.network.netty.file.transfer";
        public static final String WORKER_NETWORK_NETTY_SHUTDOWN_QUIET_PERIOD = "alluxio.worker.network.netty.shutdown.quiet.period";
        public static final String WORKER_NETWORK_NETTY_SHUTDOWN_TIMEOUT = "alluxio.worker.network.netty.shutdown.timeout";
        public static final String WORKER_NETWORK_NETTY_WATERMARK_HIGH = "alluxio.worker.network.netty.watermark.high";
        public static final String WORKER_NETWORK_NETTY_WATERMARK_LOW = "alluxio.worker.network.netty.watermark.low";
        public static final String WORKER_NETWORK_NETTY_WORKER_THREADS = "alluxio.worker.network.netty.worker.threads";
        public static final String WORKER_NETWORK_NETTY_WRITER_BUFFER_SIZE_PACKETS = "alluxio.worker.network.netty.writer.buffer.size.packets";
        public static final String WORKER_NETWORK_NETTY_READER_BUFFER_SIZE_PACKETS = "alluxio.worker.network.netty.reader.buffer.size.packets";
        public static final String WORKER_NETWORK_NETTY_READER_PACKET_SIZE_BYTES = "alluxio.worker.network.netty.reader.packet.size.bytes";
        public static final String WORKER_NETWORK_NETTY_BLOCK_READER_THREADS_MAX = "alluxio.worker.network.netty.block.reader.threads.max";
        public static final String WORKER_NETWORK_NETTY_BLOCK_WRITER_THREADS_MAX = "alluxio.worker.network.netty.block.writer.threads.max";
        public static final String WORKER_NETWORK_NETTY_FILE_READER_THREADS_MAX = "alluxio.worker.network.netty.file.reader.threads.max";
        public static final String WORKER_NETWORK_NETTY_FILE_WRITER_THREADS_MAX = "alluxio.worker.network.netty.file.writer.threads.max";
        public static final String WORKER_PRINCIPAL = "alluxio.worker.principal";
        public static final String WORKER_RPC_PORT = "alluxio.worker.port";
        public static final String WORKER_SESSION_TIMEOUT_MS = "alluxio.worker.session.timeout.ms";
        public static final String WORKER_TIERED_STORE_BLOCK_LOCK_READERS = "alluxio.worker.tieredstore.block.lock.readers";
        public static final String WORKER_TIERED_STORE_BLOCK_LOCKS = "alluxio.worker.tieredstore.block.locks";
        public static final String WORKER_TIERED_STORE_LEVEL0_ALIAS = "alluxio.worker.tieredstore.level0.alias";
        public static final String WORKER_TIERED_STORE_LEVEL0_DIRS_PATH = "alluxio.worker.tieredstore.level0.dirs.path";
        public static final String WORKER_TIERED_STORE_LEVEL0_DIRS_QUOTA = "alluxio.worker.tieredstore.level0.dirs.quota";
        public static final String WORKER_TIERED_STORE_LEVEL0_RESERVED_RATIO = "alluxio.worker.tieredstore.level0.reserved.ratio";
        public static final String WORKER_TIERED_STORE_LEVEL1_ALIAS = "alluxio.worker.tieredstore.level1.alias";
        public static final String WORKER_TIERED_STORE_LEVEL1_DIRS_PATH = "alluxio.worker.tieredstore.level1.dirs.path";
        public static final String WORKER_TIERED_STORE_LEVEL1_DIRS_QUOTA = "alluxio.worker.tieredstore.level1.dirs.quota";
        public static final String WORKER_TIERED_STORE_LEVEL1_RESERVED_RATIO = "alluxio.worker.tieredstore.level1.reserved.ratio";
        public static final String WORKER_TIERED_STORE_LEVEL2_ALIAS = "alluxio.worker.tieredstore.level2.alias";
        public static final String WORKER_TIERED_STORE_LEVEL2_DIRS_PATH = "alluxio.worker.tieredstore.level2.dirs.path";
        public static final String WORKER_TIERED_STORE_LEVEL2_DIRS_QUOTA = "alluxio.worker.tieredstore.level2.dirs.quota";
        public static final String WORKER_TIERED_STORE_LEVEL2_RESERVED_RATIO = "alluxio.worker.tieredstore.level2.reserved.ratio";
        public static final String WORKER_TIERED_STORE_LEVELS = "alluxio.worker.tieredstore.levels";
        public static final String WORKER_TIERED_STORE_RESERVER_ENABLED = "alluxio.worker.tieredstore.reserver.enabled";
        public static final String WORKER_TIERED_STORE_RESERVER_INTERVAL_MS = "alluxio.worker.tieredstore.reserver.interval.ms";
        public static final String WORKER_TIERED_STORE_RETRY = "alluxio.worker.tieredstore.retry";
        public static final String WORKER_WEB_BIND_HOST = "alluxio.worker.web.bind.host";
        public static final String WORKER_WEB_HOSTNAME = "alluxio.worker.web.hostname";
        public static final String WORKER_WEB_PORT = "alluxio.worker.web.port";
        public static final String PROXY_STREAM_CACHE_TIMEOUT_MS = "alluxio.proxy.stream.cache.timeout.ms";
        public static final String PROXY_WEB_BIND_HOST = "alluxio.proxy.web.bind.host";
        public static final String PROXY_WEB_HOSTNAME = "alluxio.proxy.web.hostname";
        public static final String PROXY_WEB_PORT = "alluxio.proxy.web.port";
        public static final String USER_BLOCK_MASTER_CLIENT_THREADS = "alluxio.user.block.master.client.threads";
        public static final String USER_BLOCK_REMOTE_READER_CLASS = "alluxio.user.block.remote.reader.class";
        public static final String USER_BLOCK_REMOTE_READ_BUFFER_SIZE_BYTES = "alluxio.user.block.remote.read.buffer.size.bytes";
        public static final String USER_BLOCK_REMOTE_WRITER_CLASS = "alluxio.user.block.remote.writer.class";
        public static final String USER_BLOCK_SIZE_BYTES_DEFAULT = "alluxio.user.block.size.bytes.default";
        public static final String USER_BLOCK_WORKER_CLIENT_THREADS = "alluxio.user.block.worker.client.threads";
        public static final String USER_BLOCK_WORKER_CLIENT_POOL_SIZE_MAX = "alluxio.user.block.worker.client.pool.size.max";
        public static final String USER_BLOCK_WORKER_CLIENT_POOL_GC_THRESHOLD_MS = "alluxio.user.block.worker.client.pool.gc.threshold.ms";
        public static final String USER_FAILED_SPACE_REQUEST_LIMITS = "alluxio.user.failed.space.request.limits";
        public static final String USER_FILE_BUFFER_BYTES = "alluxio.user.file.buffer.bytes";
        public static final String USER_FILE_CACHE_PARTIALLY_READ_BLOCK = "alluxio.user.file.cache.partially.read.block";
        public static final String USER_FILE_MASTER_CLIENT_THREADS = "alluxio.user.file.master.client.threads";
        public static final String USER_FILE_READ_TYPE_DEFAULT = "alluxio.user.file.readtype.default";
        public static final String USER_FILE_SEEK_BUFFER_SIZE_BYTES = "alluxio.user.file.seek.buffer.size.bytes";
        public static final String USER_FILE_WAITCOMPLETED_POLL_MS = "alluxio.user.file.waitcompleted.poll.ms";
        public static final String USER_FILE_WORKER_CLIENT_THREADS = "alluxio.user.file.worker.client.threads";
        public static final String USER_FILE_WORKER_CLIENT_POOL_SIZE_MAX = "alluxio.user.file.worker.client.pool.size.max";
        public static final String USER_FILE_WORKER_CLIENT_POOL_GC_THRESHOLD_MS = "alluxio.user.file.worker.client.pool.gc.threshold.ms";
        public static final String USER_FILE_WRITE_LOCATION_POLICY = "alluxio.user.file.write.location.policy.class";
        public static final String USER_FILE_WRITE_TYPE_DEFAULT = "alluxio.user.file.writetype.default";
        public static final String USER_FILE_WRITE_TIER_DEFAULT = "alluxio.user.file.write.tier.default";
        public static final String USER_HEARTBEAT_INTERVAL_MS = "alluxio.user.heartbeat.interval.ms";
        public static final String USER_LINEAGE_ENABLED = "alluxio.user.lineage.enabled";
        public static final String USER_LINEAGE_MASTER_CLIENT_THREADS = "alluxio.user.lineage.master.client.threads";
        public static final String USER_NETWORK_NETTY_CHANNEL = "alluxio.user.network.netty.channel";
        public static final String USER_NETWORK_NETTY_TIMEOUT_MS = "alluxio.user.network.netty.timeout.ms";
        public static final String USER_NETWORK_NETTY_WORKER_THREADS = "alluxio.user.network.netty.worker.threads";
        public static final String USER_NETWORK_NETTY_CHANNEL_POOL_SIZE_MAX = "alluxio.user.network.netty.channel.pool.size.max";
        public static final String USER_NETWORK_NETTY_CHANNEL_POOL_GC_THRESHOLD_MS = "alluxio.user.network.netty.channel.pool.gc.threshold.ms";
        public static final String USER_NETWORK_NETTY_CHANNEL_POOL_DISABLED = "alluxio.user.network.netty.channel.pool.disabled";
        public static final String USER_NETWORK_NETTY_WRITER_PACKET_SIZE_BYTES = "alluxio.user.network.netty.writer.packet.size.bytes";
        public static final String USER_NETWORK_NETTY_WRITER_BUFFER_SIZE_PACKETS = "alluxio.user.network.netty.writer.buffer.size.packets";
        public static final String USER_NETWORK_NETTY_READER_BUFFER_SIZE_PACKETS = "alluxio.user.network.netty.reader.buffer.size.packets";
        public static final String USER_NETWORK_NETTY_READER_CANCEL_ENABLED = "alluxio.user.network.netty.reader.cancel.enabled";
        public static final String USER_UFS_DELEGATION_ENABLED = "alluxio.user.ufs.delegation.enabled";
        public static final String USER_UFS_DELEGATION_READ_BUFFER_SIZE_BYTES = "alluxio.user.ufs.delegation.read.buffer.size.bytes";
        public static final String USER_UFS_DELEGATION_WRITE_BUFFER_SIZE_BYTES = "alluxio.user.ufs.delegation.write.buffer.size.bytes";
        public static final String USER_UFS_FILE_READER_CLASS = "alluxio.user.ufs.file.reader.class";
        public static final String USER_UFS_FILE_WRITER_CLASS = "alluxio.user.ufs.file.writer.class";
        public static final String USER_LOCAL_READER_PACKET_SIZE_BYTES = "alluxio.user.local.reader.packet.size.bytes";
        public static final String USER_LOCAL_WRITER_PACKET_SIZE_BYTES = "alluxio.user.local.writer.packet.size.bytes";
        public static final String USER_PACKET_STREAMING_ENABLED = "alluxio.user.packet.streaming.enabled";
        public static final String FUSE_CACHED_PATHS_MAX = "alluxio.fuse.cached.paths.max";
        public static final String FUSE_DEBUG_ENABLED = "alluxio.fuse.debug.enabled";
        public static final String FUSE_FS_NAME = "alluxio.fuse.fs.name";
        public static final String FUSE_FS_ROOT = "alluxio.fuse.fs.root";
        public static final String FUSE_MAXWRITE_BYTES = "alluxio.fuse.maxwrite.bytes";
        public static final String FUSE_MOUNT_DEFAULT = "alluxio.fuse.mount.default";
        public static final String SECURITY_AUTHENTICATION_CUSTOM_PROVIDER_CLASS = "alluxio.security.authentication.custom.provider.class";
        public static final String SECURITY_AUTHENTICATION_SOCKET_TIMEOUT_MS = "alluxio.security.authentication.socket.timeout.ms";
        public static final String SECURITY_AUTHENTICATION_TYPE = "alluxio.security.authentication.type";
        public static final String SECURITY_AUTHORIZATION_PERMISSION_ENABLED = "alluxio.security.authorization.permission.enabled";
        public static final String SECURITY_AUTHORIZATION_PERMISSION_SUPERGROUP = "alluxio.security.authorization.permission.supergroup";
        public static final String SECURITY_AUTHORIZATION_PERMISSION_UMASK = "alluxio.security.authorization.permission.umask";
        public static final String SECURITY_GROUP_MAPPING_CACHE_TIMEOUT_MS = "alluxio.security.group.mapping.cache.timeout.ms";
        public static final String SECURITY_GROUP_MAPPING_CLASS = "alluxio.security.group.mapping.class";
        public static final String SECURITY_LOGIN_USERNAME = "alluxio.security.login.username";

        private Name() {
        }
    }
}

