/*
 * Decompiled with CFR 0.152.
 */
package alluxio;

import alluxio.Configuration;
import alluxio.PropertyKey;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class RuntimeConstants {
    public static final String VERSION;
    public static final String ALLUXIO_JAR;
    public static final String ALLUXIO_DOCS_URL;
    public static final String ALLUXIO_DEBUG_DOCS_URL;

    private RuntimeConstants() {
    }

    static {
        String version;
        VERSION = version = Configuration.get(PropertyKey.VERSION);
        if (version.endsWith("SNAPSHOT")) {
            ALLUXIO_DOCS_URL = "http://www.alluxio.org/docs/master";
        } else {
            String[] majorMinor = version.split("\\.");
            ALLUXIO_DOCS_URL = String.format("http://www.alluxio.org/docs/%s.%s", majorMinor[0], majorMinor[1]);
        }
        ALLUXIO_JAR = "target/alluxio-" + VERSION + "-jar-with-dependencies.jar";
        ALLUXIO_DEBUG_DOCS_URL = ALLUXIO_DOCS_URL + "/en/Debugging-Guide.html";
    }
}

