/*
 * Decompiled with CFR 0.152.
 */
package alluxio;

import alluxio.AlluxioURI;
import alluxio.URI;
import java.net.URISyntaxException;
import java.util.Objects;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class StandardURI
implements URI {
    private static final long serialVersionUID = 3705239942914676079L;
    protected final java.net.URI mUri;

    public StandardURI(String scheme, String authority, String path, String query) {
        try {
            this.mUri = new java.net.URI(scheme, authority, AlluxioURI.normalizePath(path), query, null).normalize();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public String getAuthority() {
        return this.mUri.getAuthority();
    }

    @Override
    public String getHost() {
        return this.mUri.getHost();
    }

    @Override
    public String getPath() {
        return this.mUri.getPath();
    }

    @Override
    public String getQuery() {
        return this.mUri.getQuery();
    }

    @Override
    public int getPort() {
        return this.mUri.getPort();
    }

    @Override
    public String getScheme() {
        return this.mUri.getScheme();
    }

    @Override
    public boolean isAbsolute() {
        return this.getScheme() != null;
    }

    @Override
    public java.net.URI getBaseURI() {
        return this.mUri;
    }

    @Override
    public int compareTo(URI other) {
        int compare = this.compareScheme(other);
        if (compare != 0) {
            return compare;
        }
        return this.mUri.compareTo(other.getBaseURI());
    }

    private int compareScheme(URI other) {
        String scheme = this.getScheme();
        String otherScheme = other.getScheme();
        if (scheme == null && otherScheme == null) {
            return 0;
        }
        if (scheme != null) {
            if (otherScheme != null) {
                return scheme.compareToIgnoreCase(otherScheme);
            }
            return 1;
        }
        return -1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StandardURI)) {
            return false;
        }
        StandardURI that = (StandardURI)o;
        if (this.compareScheme(that) != 0) {
            return false;
        }
        return this.mUri.equals(that.getBaseURI());
    }

    public int hashCode() {
        return Objects.hash(this.mUri, this.getScheme());
    }
}

